﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web.Configuration;
using System.Data.SqlClient;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Text.RegularExpressions;//使用正则表达式
using System.IO;

/// <summary>
///Common 的摘要说明
/// </summary>
public class Common
{
    private static SqlConnection conn = new SqlConnection();
    private static SqlCommand cmd = new SqlCommand();

	public Common()
	{
		//
		//TODO: 在此处添加构造函数逻辑
		//
	}

    //打开连接
    public static void OpenConnection()
    {
        if (conn.State == ConnectionState.Closed)
        {
            conn.ConnectionString = WebConfigurationManager.ConnectionStrings["SqlConnection1"].ConnectionString;
            cmd.Connection = conn;
            conn.Open();
        }
    }

    //关闭连接
    public static void CloseConnection()
    {
        if (conn.State == ConnectionState.Open)
        {
            conn.Close();
        }
        conn.Dispose();
        cmd.Dispose();
    }

    public static void TruncateLog(string DBNAME, string logfile, int maxsize)
    {
        if (!File.Exists(logfile))
        {
            return;
        }
        FileInfo info = new FileInfo(logfile);
        if (info.Length / 1024 > maxsize)
        {
            string sql = "ALTER DATABASE " + DBNAME + " SET RECOVERY SIMPLE WITH NO_WAIT;"
                        + "ALTER DATABASE " + DBNAME + " SET RECOVERY SIMPLE;"
                        + "DBCC SHRINKFILE (N'" + DBNAME + "_Log' , 1, TRUNCATEONLY);"
                        + "ALTER DATABASE " + DBNAME + " SET RECOVERY FULL WITH NO_WAIT;"
                        + "ALTER DATABASE " + DBNAME + " SET RECOVERY FULL;";
            Common.ExecuteSql(sql);
        }
    }

    //执行一条Sql语句
    public static void ExecuteSql(string sqlStr)
    {
        try
        {
            OpenConnection();
            cmd.CommandType = CommandType.Text;
            cmd.CommandText = sqlStr;
            cmd.ExecuteNonQuery();
        }
        catch (Exception e)
        {
            throw new Exception(e.Message);
        }
        finally
        {
            CloseConnection();
        }
    }

    //显示GridView的Footer和Header,通过临时新增一行数据，然后让它不要显示来实现,但本程序后来没有使用
    public static void renderEmptyGridView(GridView EmptyGridView, string FieldNames)
    {
        DataTable dTable = new DataTable();
        char[] delimiterChars = { ',' };
        string[] colName = FieldNames.Split(delimiterChars);
        foreach (string myCol in colName)
        {
            DataColumn dColumn = new DataColumn(myCol.Trim());
            dTable.Columns.Add(dColumn);
        }

        DataRow dRow = dTable.NewRow();
        foreach (string myCol in colName)
        {
            dRow[myCol.Trim()] = DBNull.Value;
        }
        dTable.Rows.Add(dRow);

        EmptyGridView.DataSourceID = null;
        EmptyGridView.DataSource = dTable;
        EmptyGridView.DataBind();
        EmptyGridView.Rows[0].Visible = false;
    }

    //返回一个数据集
    public static DataSet dataSet(string sqlStr)
    {
        SqlDataAdapter da = new SqlDataAdapter();
        DataSet ds = new DataSet();
        try
        {
            OpenConnection();
            cmd.CommandType = CommandType.Text;
            cmd.CommandText = sqlStr;
            da.SelectCommand = cmd;
            da.Fill(ds);
        }
        catch (Exception e)
        {
            throw new Exception(e.Message);
        }
        finally
        {
            CloseConnection();
        }
        return ds;
    }

    //判断是否能查到数据
    public static bool IsDataSetNull(string sqlStr)
    {
        DataSet ds = dataSet(sqlStr);
        int ds_count = ds.Tables[0].Rows.Count;
        if (ds_count > 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    //根据Sql语句返回某行某列的值
    public static string GetName(string sql,int t)
    {
        string a = "";
        try
        {
            OpenConnection();
            cmd.CommandType = CommandType.Text;
            cmd.CommandText = sql;
            SqlDataReader sqlreader = cmd.ExecuteReader();
            if (sqlreader.HasRows)
            {
                while (sqlreader.Read())
                {
                    a = sqlreader.GetString(t);
                }
            }
            return a;
            
        }
        catch (Exception e)
        {
            throw new Exception(e.Message);
        }
        finally
        {
            CloseConnection();
        }
    }

    //根据Sql语句返回某行某列的值
    public static decimal GetNameMoney(string sql, int t)
    {
        decimal a = 0;
        try
        {
            OpenConnection();
            cmd.CommandType = CommandType.Text;
            cmd.CommandText = sql;
            SqlDataReader sqlreader = cmd.ExecuteReader();
            if (sqlreader.HasRows)
            {
                while (sqlreader.Read())
                {
                    a = sqlreader.GetDecimal(t);
                }
            }
            return a;

        }
        catch (Exception e)
        {
            throw new Exception(e.Message);
        }
        finally
        {
            CloseConnection();
        }
    }

    //根据Sql语句返回某行某列的值
    public static double GetDouble(string sql, int t)
    {
        double a = 0;
        try
        {
            OpenConnection();
            cmd.CommandType = CommandType.Text;
            cmd.CommandText = sql;
            SqlDataReader sqlreader = cmd.ExecuteReader();
            if (sqlreader.HasRows)
            {
                while (sqlreader.Read())
                {
                    a = sqlreader.GetDouble(t);
                }
            }
            return a;

        }
        catch (Exception e)
        {
            throw new Exception(e.Message);
        }
        finally
        {
            CloseConnection();
        }
    }

    //检查是否输入了已有的值
    public static bool Check(TextBox name, string sql)
    {
        TextBox servername = (TextBox)name;
        string a = servername.Text.Trim().ToString();
        bool result = false;
        DataSet ds = Common.dataSet(sql); //建立DataSet对象
        using (DataTableReader reader = ds.CreateDataReader())
        {
            do
            {
                if (reader.HasRows)
                {
                    result = true;
                }

            } while (reader.NextResult());
        }
        return result;
    }

    //检查Money数据类型的格式是否正确
    public static bool checkMoney(TextBox s)
    {
        Regex reg = new Regex(@"^\d{1,15}(?:\.\d{1,4})?$");

        string m = s.Text.Trim();
        if (reg.IsMatch(m))
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    //检查Money数据类型的格式是否正确,允许负数
    public static bool checkMoney1(TextBox s)
    {
        Regex reg = new Regex(@"^(\+|-)?\d{1,15}(?:\.\d{1,4})?$");

        string m = s.Text.Trim();
        if (reg.IsMatch(m))
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    //检查Int数据类型是否格式正确
    public static bool checkInt(TextBox s)
    {
        Regex reg = new Regex(@"^[0-9]{1}[0-9]{0,9}$");
        string m = s.Text.Trim();
        if (reg.IsMatch(m))
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    //检查Float数据类型是否格式正确
    public static bool checkFloat(TextBox s)
    {
        Regex reg = new Regex(@"^(?:0|1|0\.[0-9]{1,2})$");
        string m = s.Text.Trim();
        if (reg.IsMatch(m))
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    //删除一个文件
    public static bool FileDelete(string path)
    {
        bool result = false;
        System.IO.FileInfo file = new System.IO.FileInfo(path);
        if (file.Exists)
        {
            try
            {
                file.Delete();
                result = true;
            }
            catch (Exception e)
            {
                throw new Exception(e.Message);
            }
        }
        return result;
    }

    //检查文件是否存在
    public static bool IsFileExist(string path)
    {
        System.IO.FileInfo file = new System.IO.FileInfo(path);
        if (file.Exists)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    //生成唯一ID
    public static string GenerateUniqueID()
    {
        System.Text.StringBuilder sb = new System.Text.StringBuilder();
        string str1 = DateTime.Now.ToString("yyyyMMddHHmmss");
        Random d = new Random(Guid.NewGuid().GetHashCode());
        string str2 = d.Next(10000, 100000).ToString();
        return sb.Append(str1).Append(str2).ToString();
    }

    //生成系统日志
    public static void GenerateLog(string username, string logevent)
    {
        string login_log = "insert into [SystemLog](SystemLogDate,LogEvent,UserName) values('"
            + DateTime.Now.ToString() + "','" + logevent + "','" + username + "')";
        Common.ExecuteSql(login_log);
    }
}