﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Data;
using System.Web.Configuration;

public partial class JichuShezhi_Clothes : System.Web.UI.Page
{

    protected void Page_Load(object sender, EventArgs e)
    {
        this.keyword.Attributes.Add("onkeydown", "if(event.keyCode==13){document.all." + this.search.ClientID + ".click();}");
        ClientScript.RegisterStartupScript(ClientScript.GetType(), "myscript", "<script>clickmenu(4);</script>");
        if (!(Session["Clothes"] == null))
        {
            SqlDataSource1.SelectCommand = Session["Clothes"].ToString();
        }
        if (!Page.IsPostBack)
        {
            Session["Clothes"] = null;
            SqlDataSource1.SelectCommand = "SELECT * FROM Clothes";
            GridView1.DataBind();
        }
    }

    protected void CheckSession()
    {
        if (Session["uname"] == null)
        {
            Response.Redirect("../Login.aspx");
        }
    }

    //新建函数
    protected void NewClothes_Click(object sender, EventArgs e)
    {
        CheckSession();
        TextBox box1 = (TextBox)GridView1.FooterRow.FindControl("Box1");//衣物编号
        string a1 = box1.Text.Trim().ToString();

        TextBox box2 = (TextBox)GridView1.FooterRow.FindControl("Box2");//衣物名称
        string a2 = box2.Text.Trim().ToString();

        DropDownList list1 = (DropDownList)GridView1.FooterRow.FindControl("DropDownList1");//服务类型名称
        string a3 = list1.SelectedValue.ToString().Trim();

        DropDownList list2 = (DropDownList)GridView1.FooterRow.FindControl("DropDownList2");//衣物单位名称
        string a4 = list2.SelectedValue.ToString().Trim();

        TextBox box3 = (TextBox)GridView1.FooterRow.FindControl("Box3");//洗衣价格
        string a5 = box3.Text.Trim().ToString();

        //Label userlabel = (Label)GridView1.FooterRow.FindControl("CreateUserLabel");//创建用户
        string a6 = Session["uname"].ToString().Trim();

        //Label datelabel = (Label)GridView1.FooterRow.FindControl("CreateDateLabel");//创建日期
        string a7 = DateTime.Now.ToString();


        FileUpload picture = (FileUpload)GridView1.FooterRow.FindControl("FileUpload1");
        String pa = "~/UploadedImages/";
        string insertTime = DateTime.Now.ToString("yyyyMMddhhmmss");
        string a8 = pa + insertTime + picture.FileName.ToString();

        if (!picture.HasFile)
        {
            a8 = "";
        }

        string s1 = "Select * from [Clothes] where ClothesID='" + a1 + "'";
        //检查是否有相同衣物，类型与名称相同
        string IsExist = "select * from Clothes where ServerName='" + a3 + "' and ClothesName='" + a2 + "'";


        if (String.IsNullOrEmpty(a1) || String.IsNullOrEmpty(a2) || String.IsNullOrEmpty(a3) || String.IsNullOrEmpty(a4) || String.IsNullOrEmpty(a5))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "Test", "<script>alert('不允许插入空值！');</script>");
        }
        else if (!Common.checkMoney(box3))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "Test", "<script>alert('输入的数据格式不正确！');</script>");
        }
        else if (Common.Check(box1,s1))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "Test", "<script>alert('不允许插入相同的衣物编号！');</script>");
        }
        else if (Common.Check(box1, IsExist))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "Test", "<script>alert('不允许插入相同的衣物名称与类型！');</script>");
        }
        else if (picture.HasFile && !UploadButton_Click(picture,insertTime))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "Test", "<script>alert('文件上传失败！文件类型必须为图片类型，大小在1M以内。');</script>");
        }
        else
        {
            string sql = "insert into Clothes(ClothesID,ClothesName,ServerName,ClothesUnitName,WashPrice,CreateUser,CreateDate,ClothesPicture) values ('" + a1
                + "','" + a2 + "','" + a3 + "','" + a4 + "'," + a5 + ",'" + a6 + "','" + a7 + "','" + a8 + "')";
            Common.ExecuteSql(sql);
            GridView1.DataBind();
            GridView1.PageIndex = GridView1.PageCount;
        }
    }

    //更新函数
    protected void GridView1_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        CheckSession();
        TextBox box2 = (TextBox)GridView1.Rows[e.RowIndex].Cells[1].FindControl("TextBox2");//衣物名称
        string a2 = box2.Text.Trim().ToString();

        DropDownList list1 = (DropDownList)GridView1.Rows[e.RowIndex].Cells[2].FindControl("DropDownList3");//服务类型名称
        string a3 = list1.SelectedValue.ToString().Trim();

        DropDownList list2 = (DropDownList)GridView1.Rows[e.RowIndex].Cells[3].FindControl("DropDownList4");//衣物单位名称
        string a4 = list2.SelectedValue.ToString().Trim();

        TextBox box3 = (TextBox)GridView1.Rows[e.RowIndex].Cells[4].FindControl("TextBox5");//洗衣价格
        string a5 = box3.Text.Trim().ToString();

        string id = Convert.ToString(GridView1.DataKeys[e.RowIndex].Value);//主键的值

        FileUpload picture = (FileUpload)GridView1.Rows[e.RowIndex].Cells[7].FindControl("FileUpload2");
        String pa = "~/UploadedImages/";
        string updateTime = DateTime.Now.ToString("yyyyMMddhhmmss");
        string a8 = pa + updateTime + picture.FileName.ToString();

        //当UploadFile控件中没有选择文件时，要给它一个默认的文件URL，作为更新时使用，否则为空
        string a88 = "Select [ClothesPicture] from [Clothes] where [ClothesID]='" + id + "'";
        string a8a = Common.GetName(a88, 0);

        //检查是否有相同衣物，类型与名称相同
        string IsExist = "select * from Clothes where ServerName='" + a3 + "' and ClothesName='" + a2 + "'";

        if (!picture.HasFile)
        {
            a8 = a8a;//图片的URL默认为原数据库中的取值
        } 

        if (String.IsNullOrEmpty(a2) || String.IsNullOrEmpty(a3) || String.IsNullOrEmpty(a4) || String.IsNullOrEmpty(a5))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "Test", "<script>alert('不允许插入空值！');</script>");
        }
        else if (!Common.checkMoney(box3))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "Test", "<script>alert('输入的数据格式不正确！');</script>");
        }
        else if (Common.Check(box2, IsExist))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "Test", "<script>alert('不允许插入相同的衣物名称与类型！');</script>");
        }
        else if (picture.HasFile)
        {
            if (!UploadButton_Click(picture, updateTime))
            {
                ClientScript.RegisterStartupScript(this.GetType(), "Test", "<script>alert('文件上传失败！文件类型必须为图片类型，文件名不能太长，文件大小在1M以内。');</script>");
            }
            else
            {
                DelPicture(a8a);
                string sql = "UPDATE [Clothes] SET [ClothesName] ='" + a2 + "',[ServerName]='" + a3 + "',[ClothesUnitName]='" + a4 + "',[WashPrice]=" + a5 + ",[ClothesPicture]='" + a8 + "' WHERE [ClothesID] ='" + id + "'";
                Common.ExecuteSql(sql);
                GridView1.DataBind();
            }
            
        }
        else
        {
            string sql = "UPDATE [Clothes] SET [ClothesName] ='" + a2 + "',[ServerName]='" + a3 + "',[ClothesUnitName]='" + a4 + "',[WashPrice]=" + a5 + ",[ClothesPicture]='" + a8 + "' WHERE [ClothesID] ='" + id + "'";
            Common.ExecuteSql(sql);
            GridView1.DataBind();
        }
    }

    //显示Gridview的FooterRow
    protected void GridView1_PreRender(object sender, EventArgs e)
    {
        CheckSession();
        if (GridView1.Rows.Count == 0)
        {
            string s1 = "if object_id(N'XYZ',N'U') is not null Drop table XYZ";
            Common.ExecuteSql(s1);
            string s2 = "Create table XYZ (ClothesID Nvarchar(20),ClothesName nvarchar(20),ServerName nvarchar(20),ClothesUnitName nvarchar(20),WashPrice Money,CreateUser nvarchar(20),CreateDate datetime,ClothesPicture nvarchar(50))";
            Common.ExecuteSql(s2);
            string s3 = "Insert into XYZ values(' ',' ',' ',' ',' ',' ',' ',' ')";
            Common.ExecuteSql(s3);
            SqlDataSource1.SelectCommand = "Select * from [XYZ]";
            GridView1.DataBind();
            GridView1.Rows[0].Visible = false;
        }

        //动态指定创建用户、创建日期的值
        ((Label)GridView1.FooterRow.FindControl("CreateUserLabel")).Text = Session["uname"].ToString();
        ((Label)GridView1.FooterRow.FindControl("CreateDateLabel")).Text = DateTime.Now.ToString();
    }

    //查询功能
    protected void search_Click(object sender, EventArgs e)
    {
        CheckSession();
        string condition = list1.SelectedValue.Trim().ToString();//获取查询条件
        string sql="";
        string cond="";
        if (condition == "衣物编号")
        {
            cond = "ClothesID";
        }
        if (condition == "衣物名称")
        {
            cond = "ClothesName";
        }

        if (!String.IsNullOrEmpty(keyword.Text.Trim().ToString()))
        {
            sql = "Select * from Clothes where " + cond + "='" + keyword.Text.Trim().ToString() + "'";
            SqlDataSource1.SelectCommand = sql;
            Session["Clothes"] = sql;
            GridView1.DataBind();
            this.Page.SetFocus(keyword);
        }
        else
        {
            Session["Clothes"] = null;
            SqlDataSource1.SelectCommand = "SELECT * FROM [Clothes]";
            GridView1.DataBind();
        }
    }

    //图片上传
    protected bool UploadButton_Click(FileUpload File,string time)
    {
        String path = Server.MapPath("~/UploadedImages/");//获取与虚拟目录相对应的物理路径，将传给SaveAs函数
        bool fileOK = false;
        if (File.HasFile)
        {
            bool check = CheckFileType(File);//调用函数验证文件类型是否为图片类型
            bool check1 = CheckFileSize(File);//检查图片大小是否大于1M

            if (check && check1) //如果文件类型验证通过，将文件保存到指定的目录中
            {
                try
                {
                    File.PostedFile.SaveAs(path + time + File.FileName);
                    fileOK = true;
                }
                catch (Exception ex)
                {
                    throw new Exception(ex.Message);
                }
            }
        }
        return fileOK;
    }

    //检查文件类型
    protected bool CheckFileType(FileUpload File)
    {
        string fileName = File.FileName;
        Boolean fileOK = false; //判断文件是否可接受的布尔值
        //使用System.IO命名空间下的Path类的静态方法GetExtension获取扩展名
        String fileExtension = System.IO.Path.GetExtension(File.FileName).ToLower();

        //硬编码一个接受的文件的扩展名数组
        String[] allowedExtensions = { ".gif", ".png", ".jpeg", ".jpg", ".ico", ".bmp" };

        //循环判断上传文件的扩展名是否是可接受的
        for (int i = 0; i < allowedExtensions.Length; i++)
        {
            if (fileExtension == allowedExtensions[i])
                fileOK = true;
        }
        return fileOK;
    }

    //检查文件大小
    protected bool CheckFileSize(FileUpload File)
    {
        int imgLen = File.PostedFile.ContentLength / 1024; //KB,文件名不能超过32个字符
        int filename_len = File.FileName.Length;
        if (imgLen > 1024 || filename_len > 32)
        {
            return false;
        }
        else
        {
            return true;
        }
    }

    //删除函数，附带删除图片
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        CheckSession();
        string id = Convert.ToString(GridView1.DataKeys[e.RowIndex].Value);//主键的值
        string a88 = "Select [ClothesPicture] from [Clothes] where [ClothesID]='" + id + "'";
        string a8a = Common.GetName(a88, 0);

        if (String.IsNullOrEmpty(a8a))
        {
            string sql = "Delete from [Clothes] where [ClothesID]='" + id + "'";
            Common.ExecuteSql(sql);
            GridView1.DataBind();
        }
        else
        {
            string sql = "Delete from [Clothes] where [ClothesID]='" + id + "'";
            Common.ExecuteSql(sql);
            GridView1.DataBind();
            if (!Common.FileDelete( MapPath(a8a)))
            {
                ClientScript.RegisterStartupScript(this.GetType(), "Test", "<script>alert('删除图片失败，请手动删除');</script>");
            }
        }
    }

    //删除函数，只删除图片
    protected void DelPicture(string a8a)
    {
        if (!String.IsNullOrEmpty(a8a))
        {
            if (!Common.FileDelete(MapPath(a8a)))
            {
                ClientScript.RegisterStartupScript(this.GetType(), "Test", "<script>alert('删除图片失败，请手动删除');</script>");
            }
        }
    }

}