﻿using System;
using System.Collections.Generic;

using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Data.SqlClient; //添加对SQL Server提供者命名空间的引用
using System.Web.Configuration;//WebConfigurationManager类
using System.Data;

public partial class Login : System.Web.UI.Page
{
    string uname = ""; //全局参数，传递用户名
    string utype = ""; //全局参数，传递用户类型

    protected void Page_Load(object sender, EventArgs e)
    {
        TextBox2.Focus();
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        //从web.config中获取连接信息
        string sqlstr = WebConfigurationManager.ConnectionStrings["SqlConnection1"].ConnectionString;

        //构造SqlConnection对象用于连接数据库,使用using语句块，退出using时自动调用Dispose()方法释放连接
        using (SqlConnection conn = new SqlConnection(sqlstr))
        {
            conn.Open();

            SqlCommand command = new SqlCommand();        
            command.Connection = conn;      //指定数据库连接对象
            command.CommandText = "select * from [User] where UserName=@name and UserPassword=@password"; //指定所要执行的命令
            //SqlCommand command = new SqlCommand("Select * from User where name=@UserName", conn);
            //command.CommandType = CommandType.Text; //指定命令的类型

            //实例化一个SqlParameter对象
            SqlParameter sparameter = new SqlParameter("@name",DbType.String);
            SqlParameter sparameter1 = new SqlParameter("@password", DbType.String);
            //指定SqlParameter对象的值为函数的输入参数
            sparameter.Value = TextBox1.Text.ToString();
            sparameter1.Value = TextBox2.Text.ToString();
            //将该参数添加到SqlCommand的Parameters集合中
            command.Parameters.Add(sparameter);
            command.Parameters.Add(sparameter1);

            //调用ExecuteReader方法执行命令，返回一个SqlDataReader对象
            using (SqlDataReader sqlreader = command.ExecuteReader())
            {
                if (sqlreader.HasRows)
                {
                    while (sqlreader.Read())
                    {
                        uname = sqlreader.GetString(1);
                        utype = sqlreader.GetString(3);
                    }
                    Session["uname"] = uname.ToString();
                    Session["utype"] = utype.ToString();
                    Session["tname"] = "[temp-" + uname.ToString() + "]";

                    //记录到系统日志表中
                    string logevent = "用户登录";
                    Common.GenerateLog(Session["uname"].ToString(), logevent);

                    //清空日志，防止日志过大，日志已满，限定为3072kb
                    string dbname = "WashClothes";
                    string filename = "~/Data/WashClothes_log.LDF";
                    filename = Server.MapPath(filename);
                    int maxsize = 3072;
                    Common.TruncateLog(dbname, filename, maxsize);
                    
                    Response.Redirect("ShouyiQuyi/Shouyi.aspx");
                }
            }
            conn.Close();
        }
    }
}