﻿using System;
using System.Collections.Generic;

using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Xml;

public partial class ShouyiQuyi_Quyi : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        this.keyword.Attributes.Add("onkeydown", "if(event.keyCode==13){document.all." + this.search.ClientID + ".click();}");
        ClientScript.RegisterStartupScript(ClientScript.GetType(), "myscript", "<script>clickmenu(1);</script>");
        Text_NewQuyiDate.Attributes.Add("readonly", "true");
        D_Text_Yingshou.Attributes.Add("readonly", "true");
        D_Text_ReturnMoney.Attributes.Add("readonly", "true");
        CheckBoxQF.Enabled = false;
        D_Text_Card.Attributes.Add("readonly", "true");
        D_Text_Cash.Attributes.Add("readonly", "true");
    }

    protected void CheckSession()
    {
        if (Session["uname"] == null)
        {
            Response.Redirect("../Login.aspx");
        }
    }

    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        CheckSession();
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.ID = e.Row.Cells[0].Text;
            e.Row.Attributes.Add("onclick",
                "GridView1_RowClick('" + e.Row.Cells[0].Text + "')");
            e.Row.Attributes.Add("onmouseover", "GridView1_mouseHover(this)");
            if (e.Row.Cells[9].Text.ToString() == "否")
            {
                e.Row.Attributes.Add("style", "color:red;");
            }
            e.Row.Cells[2].Text = e.Row.Cells[2].Text.Substring(0, 10);
        }
    }
    
    protected void GridView2_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        CheckSession();
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.ID = e.Row.Cells[1].Text;
            e.Row.Attributes.Add("onmouseover", "GridView2_mouseHover(this)");
            e.Row.Attributes.Add("onmouseout", "GridView2_mouseOut(this)");

            Label quzou = (Label)e.Row.Cells[15].FindControl("Label15");
            Label chongxi = (Label)e.Row.Cells[16].FindControl("Label16");
            Label peifu = (Label)e.Row.Cells[17].FindControl("Label17");
            CheckBox check = (CheckBox)e.Row.Cells[0].FindControl("QuyiCheckboxD");
            if (quzou.Text.ToString() == "是")
            {
                e.Row.Cells[15].Attributes.Add("style", "color:red;");
                check.Checked = false;
            }
            if (chongxi.Text.ToString() == "是")
            {
                e.Row.Cells[16].Attributes.Add("style", "color:red;");
            }
            if (peifu.Text.ToString() == "是")
            {
                e.Row.Cells[17].Attributes.Add("style", "color:red;");
            }
        }
    }

    //实现全选功能
    protected void GridView2_PreRender(object sender, EventArgs e)
    {
        CheckSession();
        //页面第一次载入时,GridView2初始化
        if (hdnID.Value == "HIDDEN_DEFAULT_VALUE")
        {
            if (GridView1.Rows.Count >= 1)
            {
                string shouyiID = GridView1.Rows[0].Cells[0].Text.ToString();
                SqlDataSource2.SelectCommand = "select * from QuyiView where ShouyiID='" + shouyiID + "'";
            }
        }

        //如果为空，依然显示表头
        if (GridView2.Rows.Count == 0)
        {
            string s1 = "if object_id(N'XYZ',N'U') is not null Drop table XYZ";
            Common.ExecuteSql(s1);
            string s2 = "Create table XYZ ([ShouyiID] [nvarchar](20),[ShouyiDetailID] [nvarchar](20),[ClothesName] [nvarchar](20),[ServerName] [nvarchar](20),[ClothesColorName] [nvarchar](10),[ClothesBrandName] [nvarchar](20),[ClothesAttachmentName] [nvarchar](50),[ClothesBlemishName] [nvarchar](50),[AdditionalService] [nvarchar](50),[AdditionalPrice] [money],[PlaceNo] [nvarchar],[ClothesNumber] [int],[WashPrice] [money],[Discount] [float],[TotalPrice] [money],[IsTaken] [nchar](1),[IsChongxi] [nchar](1),[IsPei] [nchar](1))";
            Common.ExecuteSql(s2);
            string s3 = "Insert into XYZ values(' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ')";
            Common.ExecuteSql(s3);
            SqlDataSource2.SelectCommand = "Select * from [XYZ]";
            GridView2.DataBind();
            GridView2.Rows[0].Visible = false;
        }
    }

    //在GridView1中点击不同的行，GridView2的数据动态绑定
    protected void Grid2Bound(object sender, EventArgs e)
    {
        CheckSession();
        string shouyiID = hdnID.Value.ToString();
        SqlDataSource2.SelectCommand = "select * from QuyiView where ShouyiID='" + shouyiID + "'";
        GridView2.DataBind();
    }

    //读取xml中的积分
    protected int readjifen()
    {
        XmlDocument fen = new XmlDocument();
        fen.Load(Server.MapPath("~/xml.xml"));
        string path = "Config/Jifen/MoneyPerJifen";
        string ji = fen.SelectSingleNode(path).InnerText.ToString();
        return Convert.ToInt32(ji);
    }

    //查询
    protected void Search_Click(object sender, EventArgs e)
    {
        CheckSession();
        string key = keyword.Text.Trim().ToString();
        if (!String.IsNullOrEmpty(key))
        {
            string sql = "Select * from [QuView] where [MemberCard] like '%" + key
                + "%' or [ShouyiID] like '%" + key + "%' or [MemberName] like '%" + key
                + "%' or [Phone] like '%" + key + "%'";
            SqlDataSource1.SelectCommand = sql;
            Session["QuView"] = sql;
            GridView1.DataBind();
            this.Page.SetFocus(keyword);
            hdnID.Value = "HIDDEN_DEFAULT_VALUE";
        }
        else
        {
            Session["QuView"] = null;
            SqlDataSource1.SelectCommand = "SELECT * FROM [QuView]";
            GridView1.DataBind();
            this.Page.SetFocus(keyword);
        }
    }

    protected void GridView1_PreRender(object sender, EventArgs e)
    {
        CheckSession();
        if (GridView1.Rows.Count == 0)
        {
            string s1 = "if object_id(N'XYZ',N'U') is not null Drop table XYZ";
            Common.ExecuteSql(s1);
            string s2 = "Create table XYZ ([ShouyiID] [nvarchar](20),[ShouyiDate] [datetime],[QuyiDate] [datetime],[MemberCard] [nvarchar](20),[MemberName] [nvarchar](20),[Phone] [nvarchar](20),[CardMoney] [money],[Yingshou] [money],[Shishou] [money],[IsPay] [nvarchar](10),[UserName] [nvarchar](20),[Beizhu] [nvarchar](100))";
            Common.ExecuteSql(s2);
            string s3 = "Insert into XYZ values(' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ')";
            Common.ExecuteSql(s3);
            SqlDataSource1.SelectCommand = "Select * from [XYZ]";
            GridView1.DataBind();
            GridView1.Rows[0].Visible = false;

            Grid2Bound(sender, e);
        }
    }

    //取衣结单
    protected void WashOKButton_Click(object sender, EventArgs e)
    {
        CheckSession();
        //输入的信息
        decimal yinshou = Convert.ToDecimal(D_Text_Yingshou.Text);
        decimal shishou = yinshou; //实收金额，先赋初值
        decimal cardfu = Convert.ToDecimal(D_Text_Card.Text);
        decimal cashfu = Convert.ToDecimal(D_Text_Cash.Text);
        decimal returnMoney = Convert.ToDecimal(D_Text_ReturnMoney.Text);
        decimal cash = cashfu - returnMoney;//现金收入
        string beizhu = D_Text_Bei.Text.Trim().ToString();
        string mima = D_Text_Mima.Text.Trim().ToString();
        string mcard = hidden_mcard.Value.ToString();
        string shouyiID = hdnID.Value.ToString();
        string quyiDate = DateTime.Now.ToString();
        string quyiDetailSql = hidden_shouyiDetailID.Value.ToString();

        //获取会员的信息
        decimal cardMoney;
        string memberState;
        string memsql = "select * from [Member] where [MemberCard]='" + mcard + "'";
        DataSet memberinfo = Common.dataSet(memsql);
        DataRow mrow = memberinfo.Tables[0].Rows[0];
        if (memberinfo.Tables[0].Rows.Count != 0)
        {
            cardMoney = Convert.ToDecimal(mrow["CardMoney"]);//卡内余额
            memberState = mrow["State"].ToString();
        }
        else
        {
            ClientScript.RegisterStartupScript(this.GetType(), "memberscript", "<script>alert('无法获取到会员信息!');</script>");
            return;
        }

        //得到应该增加的积分
        int jifen = readjifen();
        int point = (int)(yinshou / jifen);//会员新增的积分

        //验证会员密码
        string mm = mrow["MemberPassword"].ToString();
        if (mm != mima)
        {
            ClientScript.RegisterStartupScript(this.GetType(), "mimascript", "<script>alert('会员卡密码输入错误!');</script>");
            return;
        }

        //验证会员状态
        if (memberState == "已挂失")
        {
            ClientScript.RegisterStartupScript(this.GetType(), "statescript", "<script>alert('当前会员已挂失，无法领取衣物，请先修改会员资料!')</script>");
            return;
        }

        //具体取衣过程
        string connectionStr = ConfigurationManager.ConnectionStrings["SqlConnection1"].ConnectionString;
        SqlTransaction transaction = null;
        using (SqlConnection conn = new SqlConnection(connectionStr))
        {
            conn.Open();
            try
            {
                transaction = conn.BeginTransaction();
                SqlCommand cmd = new SqlCommand();
                cmd.Connection = conn;
                cmd.Transaction = transaction;

                if (yinshou == 0 || CheckBoxQF.Checked == true)//如果不需要付款，则更新详细收衣表（取走否）、收衣表（取衣时间）
                {
                    string shou = "update [Shouyi] set [QuyiDate]='" + quyiDate + "' where [ShouyiID]='" + shouyiID + "'";
                    string detail = "update [ShouyiDetail] set [IsTaken]='是' where 1<1" + quyiDetailSql;

                    cmd.CommandText = detail;
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = shou;
                    cmd.ExecuteNonQuery();
                }
                else//还需要付款，更新会员表、详细收衣表、收衣表
                {
                    if (cashfu + cardfu >= yinshou)
                        shishou = yinshou;
                    else
                        shishou = cashfu + cardfu;
                    string ispay = (shishou == yinshou) ? "是" : "否";//是否足额付款
                    if (ispay == "否")
                    {
                        ClientScript.RegisterStartupScript(this.GetType(), "ispayscript", "<script>alert('尚未付款或付款不足，无法完成取衣！')</script>");
                        return;
                    }
                    else if (cardfu > cardMoney)
                    {
                        ClientScript.RegisterStartupScript(this.GetType(), "cardfuscript", "<script>alert('会员卡余额不足,请选择现金付款或进行会员充值！')</script>");
                        return;
                    }
                    else
                    {
                        string hui = "Update Member set CardMoney=CardMoney-" + cardfu
                            + ",ConsumeMoney=ConsumeMoney+" + yinshou
                            + ",ConsumeTimes=ConsumeTimes+1, MemberPoint=MemberPoint+"
                            + point + ",RecentConsumeDate='" + quyiDate + "' where MemberCard='"
                            + mcard + "'";
                        string shouyi = "update [Shouyi] set [QuyiDate]='" + quyiDate 
                            + "', Shishou=" + yinshou + ", IsPay='是', [UserName]='" + Session["uname"].ToString() + "',Beizhu='" + beizhu
                            + "', CashMoney=" + cash + ", CardMoney=" + cardfu + ", PayDate='" + DateTime.Now.ToString()
                            + "' where [ShouyiID]='" + shouyiID + "'";
                        string detail_sql = "update [ShouyiDetail] set [IsTaken]='是' where 1<1" 
                            + quyiDetailSql;

                        cmd.CommandText = hui;
                        cmd.ExecuteNonQuery();
                        cmd.CommandText = shouyi;
                        cmd.ExecuteNonQuery();
                        cmd.CommandText = detail_sql;
                        cmd.ExecuteNonQuery();
                    }
                }

                //提交事务
                transaction.Commit();
                ClientScript.RegisterStartupScript(this.GetType(), "quyiokscript", "<script>alert('取衣成功!');</script>");
                GridView1.DataBind();
                hdnID.Value = "HIDDEN_DEFAULT_VALUE";
                Grid2Bound(sender, e);
            }
            catch (Exception ex)
            {
                //事务回滚
                transaction.Rollback();
                throw ex;
            }
            finally
            {
                conn.Close();
            }
        }   
    }

    //返回重洗
    protected void WashAgainButton_Click(object sender, EventArgs e)
    {
        CheckSession();
        string shouyiID = hdnID.Value.ToString();
        string mcard = hidden_mcard.Value.ToString();
        string newdate = Text_NewQuyiDate.Text.ToString();
        string beizhu = D_Text_Bei.Text.Trim().ToString();
        string user = Session["uname"].ToString();
        string mima = D_Text_Mima.Text.Trim().ToString();

        //获取会员的信息
        string memberState;
        string memsql = "select * from [Member] where [MemberCard]='" + mcard + "'";
        DataSet memberinfo = Common.dataSet(memsql);
        DataRow mrow = memberinfo.Tables[0].Rows[0];
        if (memberinfo.Tables[0].Rows.Count != 0)
        {
            memberState = mrow["State"].ToString();
        }
        else
        {
            ClientScript.RegisterStartupScript(this.GetType(), "memberscript1", "<script>alert('无法获取到会员信息!');</script>");
            return;
        }

        //验证会员密码
        string mm = mrow["MemberPassword"].ToString();
        if (mm != mima)
        {
            ClientScript.RegisterStartupScript(this.GetType(), "mimascript1", "<script>alert('会员卡密码输入错误!');</script>");
            return;
        }

        //验证会员状态
        if (memberState == "已挂失")
        {
            ClientScript.RegisterStartupScript(this.GetType(), "statescript1", "<script>alert('当前会员已挂失，无法领取衣物，请先修改会员资料!')</script>");
            return;
        }

        //具体过程
        string connectionStr = ConfigurationManager.ConnectionStrings["SqlConnection1"].ConnectionString;
        SqlTransaction transaction = null;
        using (SqlConnection conn = new SqlConnection(connectionStr))
        {
            conn.Open();
            try
            {
                transaction = conn.BeginTransaction();
                SqlCommand cmd = new SqlCommand();
                cmd.Connection = conn;
                cmd.Transaction = transaction;

                string shou = "update [Shouyi] set [QuyiDate]='" + newdate + "' where [ShouyiID]='" + shouyiID + "'";
                cmd.CommandText = shou;
                cmd.ExecuteNonQuery();

                string quyiDetailSql = hidden_shouyiDetailID.Value.ToString();
                string[] array = quyiDetailSql.Substring(0, quyiDetailSql.Length - 1).Split(',');

                //插入返回重洗表,更新详细收衣表
                for (int i = 0; i < array.Length; i++)
                {
                    string chongxi = "insert into [WashAgain](ShouyiDetailID,MemberCard,NewClothesTakeTime,ReWashReason,UserName,AgainDate) values('"
                        + array[i] + "','" + mcard + "','" + newdate + "','" + beizhu + "','" + user + "','" + DateTime.Now.ToString() + "')";
                    string shouyisql = "update [ShouyiDetail] set IsChongxi='是' where ShouyiDetailID='"
                        + array[i] + "'";
                    cmd.CommandText = chongxi;
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = shouyisql;
                    cmd.ExecuteNonQuery();
                }

                //提交事务
                transaction.Commit();
                ClientScript.RegisterStartupScript(this.GetType(), "washscript", "<script>alert('重洗完成!');</script>");
                GridView1.DataBind();
                hdnID.Value = "HIDDEN_DEFAULT_VALUE";
                Grid2Bound(sender, e);
            }
            catch (Exception ex)
            {
                //事务回滚
                transaction.Rollback();
                throw ex;
            }
            finally
            {
                conn.Close();
            }
        }
    }

    //退赔衣物
    protected void WashFailButton_Click(object sender, EventArgs e)
    {
        CheckSession();
        string mcard = hidden_mcard.Value.ToString();
        string beizhu = D_Text_Bei.Text.Trim().ToString();
        string user = Session["uname"].ToString();
        string mima = D_Text_Mima.Text.Trim().ToString();
        decimal payback = Convert.ToDecimal(D_Text_Tuipei.Text.Trim());//赔付金额

        //获取会员的信息
        string memberState;
        string memsql = "select * from [Member] where [MemberCard]='" + mcard + "'";
        DataSet memberinfo = Common.dataSet(memsql);
        DataRow mrow = memberinfo.Tables[0].Rows[0];
        if (memberinfo.Tables[0].Rows.Count != 0)
        {
            memberState = mrow["State"].ToString();
        }
        else
        {
            ClientScript.RegisterStartupScript(this.GetType(), "memberscript12", "<script>alert('无法获取到会员信息!');</script>");
            return;
        }

        //验证会员密码
        string mm = mrow["MemberPassword"].ToString();
        if (mm != mima)
        {
            ClientScript.RegisterStartupScript(this.GetType(), "mimascript12", "<script>alert('会员卡密码输入错误!');</script>");
            return;
        }

        //验证会员状态
        if (memberState == "已挂失")
        {
            ClientScript.RegisterStartupScript(this.GetType(), "statescript12", "<script>alert('当前会员已挂失，无法领取衣物，请先修改会员资料!')</script>");
            return;
        }

        //具体过程
        string connectionStr = ConfigurationManager.ConnectionStrings["SqlConnection1"].ConnectionString;
        SqlTransaction transaction = null;
        using (SqlConnection conn = new SqlConnection(connectionStr))
        {
            conn.Open();
            try
            {
                transaction = conn.BeginTransaction();
                SqlCommand cmd = new SqlCommand();
                cmd.Connection = conn;
                cmd.Transaction = transaction;

                string quyiDetailSql = hidden_shouyiDetailID.Value.ToString();
                string[] array = quyiDetailSql.Substring(0, quyiDetailSql.Length - 1).Split(',');

                //插入退赔记录表,更新详细收衣表
                for (int i = 0; i < array.Length; i++)
                {
                    string pei = "insert into [WashFail](ShouyiDetailID,MemberCard,RestituteMoney,RestituteReason,RestituteDate,UserName) values('"
                        + array[i] + "','" + mcard + "'," + payback + ",'" + beizhu + "','" + DateTime.Now.ToString() + "','" + user + "')";
                    string shouyisql = "update [ShouyiDetail] set IsPei='是' where ShouyiDetailID='"
                        + array[i] + "'";
                    cmd.CommandText = pei;
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = shouyisql;
                    cmd.ExecuteNonQuery();
                }

                //记录到日志中
                string logevent = "退赔衣物，退赔金额：" + payback;
                Common.GenerateLog(Session["uname"].ToString(), logevent);

                //提交事务
                transaction.Commit();
                ClientScript.RegisterStartupScript(this.GetType(), "peiscript", "<script>alert('赔付完成!');</script>");
                GridView1.DataBind();
                hdnID.Value = "HIDDEN_DEFAULT_VALUE";
                Grid2Bound(sender, e);
            }
            catch (Exception ex)
            {
                //事务回滚
                transaction.Rollback();
                throw ex;
            }
            finally
            {
                conn.Close();
            }
        }
    }

    //撤销订单
    protected void WashCancelButton_Click(object sender, EventArgs e)
    {
        CheckSession();
        if (hdnID.Value == "HIDDEN_DEFAULT_VALUE")
        {
            ClientScript.RegisterStartupScript(this.GetType(), "cascript", "<script>alert('错误，没有可以撤销的订单!');</script>");
            return;
        }

        //输入信息
        string shouyiID = hdnID.Value.ToString();
        string mcard = hidden_mcard.Value.ToString();
        string beizhu = D_Text_Bei.Text.Trim().ToString();
        string user = Session["uname"].ToString();
        string mima = D_Text_Mima.Text.Trim().ToString();
        decimal yinshou = Convert.ToDecimal(D_Text_Yingshou.Text);

        //获取会员的信息
        string memberState;
        string memsql = "select * from [Member] where [MemberCard]='" + mcard + "'";
        DataSet memberinfo = Common.dataSet(memsql);
        DataRow mrow = memberinfo.Tables[0].Rows[0];
        if (memberinfo.Tables[0].Rows.Count != 0)
        {
            memberState = mrow["State"].ToString();
        }
        else
        {
            ClientScript.RegisterStartupScript(this.GetType(), "memberscript1", "<script>alert('无法获取到会员信息!');</script>");
            return;
        }

        //验证会员密码
        string mm = mrow["MemberPassword"].ToString();
        if (mm != mima)
        {
            ClientScript.RegisterStartupScript(this.GetType(), "mimascript1", "<script>alert('会员卡密码输入错误!');</script>");
            return;
        }

        //验证会员状态
        if (memberState == "已挂失")
        {
            ClientScript.RegisterStartupScript(this.GetType(), "statescript1", "<script>alert('当前会员已挂失，无法领取衣物，请先修改会员资料!')</script>");
            return;
        }

        //应该减少的积分
        int jifen = readjifen();
        int point = (int)(yinshou / jifen);//会员新增的积分

        //具体过程
        string connectionStr = ConfigurationManager.ConnectionStrings["SqlConnection1"].ConnectionString;
        SqlTransaction transaction = null;
        using (SqlConnection conn = new SqlConnection(connectionStr))
        {
            conn.Open();
            try
            {
                transaction = conn.BeginTransaction();
                SqlCommand cmd = new SqlCommand();
                cmd.Connection = conn;
                cmd.Transaction = transaction;

                if (yinshou == 0)//已经付款,插入撤销订单表,修改会员表,删除收衣表中的记录
                {
                    string yinsql = "select Yingshou from Shouyi where ShouyiID='" + shouyiID + "'";
                    yinshou = Common.GetNameMoney(yinsql, 0);
                    string cancel = "insert into [WashCancel](ShouyiID,MemberCard,CancelReason,ReturnMoney,UserName,CancelDate) values('"
                        + shouyiID + "','" + mcard + "','" + beizhu + "'," + yinshou + ",'" + user + "','" + DateTime.Now.ToString() + "')";
                    string msql = "update [Member] set ConsumeMoney=ConsumeMoney-" + yinshou
                        + ",ConsumeTimes=ConsumeTimes-1,MemberPoint=MemberPoint-" + point
                        + " where MemberCard='" + mcard + "'";
                    //删除收衣表中数据，级联删除详细收衣表中信息
                    string del_shouyi = "delete from [Shouyi] where ShouyiID='" + shouyiID + "'";

                    cmd.CommandText = cancel;
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = msql;
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = del_shouyi;
                    cmd.ExecuteNonQuery();

                    //记录到日志
                    string logevent = "撤销订单：" + shouyiID + "；返还金额：" + yinshou;
                    Common.GenerateLog(Session["uname"].ToString(), logevent);

                }
                else//尚未付款,插入撤销订单表
                {
                    yinshou = 0;
                    string cancel = "insert into [WashCancel](ShouyiID,MemberCard,CancelReason,ReturnMoney,UserName,CancelDate) values('"
                        + shouyiID + "','" + mcard + "','" + beizhu + "'," + yinshou + ",'" + user + "','" + DateTime.Now.ToString() + "')";
                    string del_shouyi = "delete from [Shouyi] where ShouyiID='" + shouyiID + "'";
                    cmd.CommandText = cancel;
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = del_shouyi;
                    cmd.ExecuteNonQuery();

                    //记录日志
                    string logevent = "撤销订单：" + shouyiID + ",顾客尚未付款";
                    Common.GenerateLog(Session["uname"].ToString(), logevent);
                }

                //提交事务
                transaction.Commit();
                ClientScript.RegisterStartupScript(this.GetType(), "washscript", "<script>alert('撤销完成，请返还客户现金" + yinshou + "!');</script>");
                GridView1.DataBind();
                hdnID.Value = "HIDDEN_DEFAULT_VALUE";
                Grid2Bound(sender, e);
            }
            catch (Exception ex)
            {
                //事务回滚
                transaction.Rollback();
                throw ex;
            }
            finally
            {
                conn.Close();
            }
        }
    }
}