﻿using System;
using System.Collections.Generic;
using System.Web.UI.HtmlControls;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Data;
using System.Data.SqlClient;
using System.Xml;
using System.Configuration;

public partial class ShouyiQuyi_Shouyi : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        this.keyword.Attributes.Add("onkeydown", "if(event.keyCode==13){document.all." + this.search.ClientID + ".click();}");
        ClientScript.RegisterStartupScript(ClientScript.GetType(), "myscript", "<script>clickmenu(1);</script>");
        if (!Page.IsPostBack)
        {
        }
        Text_QuyiDate.Attributes.Add("readonly", "true");//不能在前台添加readonly
        SqlDataSourceX1.DataBind();//绑定动态sql语句，每个登录用户对应一张临时表
    }

    protected void CheckSession()
    {
        if (Session["uname"] == null)
        {
            Response.Redirect("../Login.aspx");
        }
    }

    //读取xml中的积分
    protected int readjifen()
    {
        XmlDocument fen = new XmlDocument();
        fen.Load(Server.MapPath("~/xml.xml"));
        string path = "Config/Jifen/MoneyPerJifen";
        string ji = fen.SelectSingleNode(path).InnerText.ToString();
        return Convert.ToInt32(ji);
    }

    //更新
    protected void GridView1_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        CheckSession();
        DropDownList colorname = (DropDownList)GridView1.Rows[e.RowIndex].Cells[0].FindControl("DropDownListCColor1");
        DropDownList brandname = (DropDownList)GridView1.Rows[e.RowIndex].Cells[0].FindControl("DropDownListCBrand1");
        TextBox cAttach = (TextBox)GridView1.Rows[e.RowIndex].Cells[0].FindControl("B_Text_CAttachName");
        TextBox cBle = (TextBox)GridView1.Rows[e.RowIndex].Cells[0].FindControl("B_TextBox_BlemishName");
        TextBox aService = (TextBox)GridView1.Rows[e.RowIndex].Cells[0].FindControl("B_TextBox_AddService");
        TextBox aPrice = (TextBox)GridView1.Rows[e.RowIndex].Cells[0].FindControl("B_Text_AddPrice");
        DropDownList place1 = (DropDownList)GridView1.Rows[e.RowIndex].Cells[0].FindControl("DropDownListPlace2");
        TextBox count = (TextBox)GridView1.Rows[e.RowIndex].Cells[0].FindControl("B_Text_CNum");
        TextBox washPrice = (TextBox)GridView1.Rows[e.RowIndex].Cells[0].FindControl("B_Text_Price");
        TextBox disc = (TextBox)GridView1.Rows[e.RowIndex].Cells[0].FindControl("B_Text_Discount");
        TextBox tp = (TextBox)GridView1.Rows[e.RowIndex].Cells[0].FindControl("B_Text_TotalPrice");

        string color3 = colorname.SelectedValue.Trim().ToString();//衣物颜色
        string brand3 = brandname.SelectedValue.Trim().ToString();//衣物品牌
        string attach = cAttach.Text.Trim().ToString(); //衣物附件
        string ble = cBle.Text.Trim().ToString(); //衣物瑕疵
        string addservice = aService.Text.Trim().ToString();//附加服务
        string addprice = aPrice.Text.Trim().ToString();//附加价格
        string place = place1.SelectedValue.Trim().ToString();//挂衣号
        string co = count.Text.Trim().ToString(); //数量
        string price = washPrice.Text.Trim().ToString();//单价
        string dis = disc.Text.Trim().ToString(); //折扣
        string tp3 = tp.Text.Trim().ToString(); //小计
        string id = GridView1.DataKeys[e.RowIndex].Value.ToString();

        if (String.IsNullOrEmpty(co) || String.IsNullOrEmpty(price) || String.IsNullOrEmpty(dis) || String.IsNullOrEmpty(addprice) || String.IsNullOrEmpty(tp3))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "scriptadd", "<script>alert('不允许插入空值!');</script>");
        }
        else
        {
            string sql = "UPDATE " + Session["tname"].ToString() + " SET ClothesColorName='" + color3 + "',ClothesBrandName='" + brand3 + "',ClothesAttachmentName='" +
                attach + "',ClothesBlemishName='" + ble + "',AdditionalService='" + addservice + "',AdditionalPrice=" + addprice + ",PlaceNo='" + place + "',ClothesNumber='" + co + "',WashPrice=" +
                price + ",Discount=" + dis + ",TotalPrice=" + tp3 + " WHERE ShouyiDetailID='" + id + "'";
            Common.ExecuteSql(sql);
            GridView1.DataBind();
        }
    }

    //GridView1预处理
    protected void GridView1_PreRender(object sender, EventArgs e)
    {
        CheckSession();
        //在GridView为空时显示页脚
        if (GridView1.Rows.Count == 0)
        {
            string xx1 = "if object_id(N'XYZ',N'U') is not null Drop table XYZ";
            Common.ExecuteSql(xx1);
            string xx2 = "Create table XYZ (ShouyiDetailID nvarchar(20),ClothesName nvarchar(20),ServerName nvarchar(20),ClothesColorName nvarchar(10),ClothesBrandName nvarchar(20),ClothesAttachmentName nvarchar(50),ClothesBlemishName nvarchar(50), AdditionalService nvarchar(50), AdditionalPrice money, PlaceNo nvarchar(10),ClothesNumber int,WashPrice money,Discount float,TotalPrice money)";
            Common.ExecuteSql(xx2);
            string xx3 = "Insert into XYZ(ShouyiDetailID, ClothesName,ServerName,ClothesColorName,ClothesBrandName,ClothesAttachmentName,ClothesBlemishName,AdditionalService,AdditionalPrice,PlaceNo,ClothesNumber,WashPrice,Discount,TotalPrice) values(' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ')";
            Common.ExecuteSql(xx3);
            SqlDataSourceX1.SelectCommand = "Select * from XYZ";
            GridView1.DataBind();
            GridView1.Rows[0].Visible = false;
        }

        DropDownList sname = (DropDownList)GridView1.FooterRow.FindControl("DropDownListSName");
        DropDownList cname = (DropDownList)GridView1.FooterRow.FindControl("DropDownListCName");
        DropDownList colorname = (DropDownList)GridView1.FooterRow.FindControl("DropDownListCColor");
        DropDownList brandname = (DropDownList)GridView1.FooterRow.FindControl("DropDownListCBrand");
        DropDownList place1 = (DropDownList)GridView1.FooterRow.FindControl("DropDownListPlace1");
        TextBox washPrice = (TextBox)GridView1.FooterRow.FindControl("C_Text_Price");
        TextBox addPrice = (TextBox)GridView1.FooterRow.FindControl("C_Text_AddPrice");
        TextBox disc = (TextBox)GridView1.FooterRow.FindControl("C_Text_Discount");
        if (!String.IsNullOrEmpty(Text_Discount.Text))
        {
            disc.Text = Text_Discount.Text.ToString();
        }

        if (colorname.Items.FindByText("普通颜色") != null)
        {
            colorname.ClearSelection();
            colorname.Items.FindByText("普通颜色").Selected = true;
        }
        else
        {
            colorname.Items.Add("普通颜色");
            colorname.ClearSelection();
            colorname.Items.FindByText("普通颜色").Selected = true;
        }

        if (brandname.Items.FindByText("普通品牌") != null)
        {
            brandname.ClearSelection();
            brandname.Items.FindByText("普通品牌").Selected = true;
        }
        else
        {
            brandname.Items.Add("普通品牌");
            brandname.ClearSelection();
            brandname.Items.FindByText("普通品牌").Selected = true;
        }

        if (place1.Items.FindByText("不使用") != null)
        {
            place1.ClearSelection();
            place1.Items.FindByText("不使用").Selected = true;
        }
        else
        {
            place1.Items.Add("不使用");
            place1.ClearSelection();
            place1.Items.FindByText("不使用").Selected = true;
        }
        
        Session["sname"] = sname.SelectedValue.ToString(); //服务类型
        Session["cname"] = cname.SelectedValue.ToString(); //衣物名称
        string sname1 = Session["sname"].ToString();//初始化衣物单价
        string cname1 = Session["cname"].ToString();
        if (!String.IsNullOrEmpty(sname1) && !String.IsNullOrEmpty(cname1))
        {
            string s1 = "Select WashPrice from Clothes where ClothesName='" + cname1 + "' and ServerName='" + sname1 + "'";
            decimal result = Common.GetNameMoney(s1, 0);
            if (result != 0)
            {
                washPrice.Text = result.ToString();
            }
            else
            {
                washPrice.Text = "";
            }
        }
        ClientScript.RegisterStartupScript(ClientScript.GetType(), "myscriptr", "<script>isNumber('C_Text_CNum','C_Text_Price','C_Text_Discount','C_Text_AddPrice','C_Text_TotalPrice','s2');</script>");

        //加入只读属性，不能在控件属性中加，否则服务端读取不到数值
        ((TextBox)GridView1.FooterRow.FindControl("C_Text_TotalPrice")).Attributes.Add("readonly", "true");

        updateYingshou();
        
    }

    //衣物名称
    protected void DropDownListCName_SelectedIndexChanged(object sender, EventArgs e)
    {
        CheckSession();
    }

    //服务类型
    protected void DropDownListSName_SelectedIndexChanged(object sender, EventArgs e)
    {
        CheckSession();
        DropDownList sname = (DropDownList)GridView1.FooterRow.FindControl("DropDownListSName");
        DropDownList cname = (DropDownList)GridView1.FooterRow.FindControl("DropDownListCName");
        TextBox washPrice = (TextBox)GridView1.FooterRow.FindControl("C_Text_Price");

        //DropDownList两级联动，动态绑定数据源，更新衣物名称列表,否则取不到正确的值
        string sq = "Select [ClothesName] from [Clothes] where [ServerName]='" + sname.SelectedValue.ToString() + "'";
        DataSet dd = Common.dataSet(sq);
        cname.DataSourceID = null;
        cname.DataSource = dd;
        cname.DataTextField = "ClothesName";
        cname.DataBind();

    }

    //查询
    protected void Search_Click(object sender, EventArgs e)
    {
        CheckSession();
        if (!String.IsNullOrEmpty(keyword.Text.Trim().ToString()))
        {
            string sql1 = "Select * from [Member] where [MemberCard]='" + keyword.Text.Trim().ToString() + "'";
            DataSet member = Common.dataSet(sql1);//返回数据集
            DataTable t1 = member.Tables[0];//复制数据
            DataRowCollection c1 = t1.Rows;
            DataRow row1;

            //逐行遍历，为各控件赋值
            for (int i = 0; i < c1.Count; i++)
            {
                row1 = c1[i];
                Text_MemberName.Text = row1[1].ToString();
                Text_MemberSex.Text = row1[3].ToString();
                Text_MemberState.Text = row1[12].ToString();
                Text_ConsumeMoney.Text = row1[6].ToString();
                Text_CardMoney.Text = row1[5].ToString();
                Text_MemberLevel.Text = row1[8].ToString();
                Text_MemberPoint.Text = row1[9].ToString();
                Text_Phone.Text = row1[4].ToString();
                Text_MemberCard.Text = row1[0].ToString();
                
            }
            string sid1 = "S" + Common.GenerateUniqueID();//初始化收衣单号
            Text_ShouyiID.Text = sid1;
            if (!String.IsNullOrEmpty(Text_MemberLevel.Text))//初始化折扣
            {
                string sq = "Select Discount from MemberLevel where MemberLevelName='" + Text_MemberLevel.Text.ToString() + "'";
                double discount = Common.GetDouble(sq, 0);
                Text_Discount.Text = discount.ToString();
            }
            
            if (c1.Count == 0)
            {
                Clear();
            }
            GridView1.DataBind();
            this.Page.SetFocus(keyword);
        }
        else
        {
            Clear();
        }
    }

    //清空所有控件的值
    protected void Clear()
    {
        Text_MemberName.Text = "";
        Text_MemberSex.Text = "";
        Text_MemberState.Text = "";
        Text_ConsumeMoney.Text = "";
        Text_CardMoney.Text = "";
        Text_MemberLevel.Text = "";
        Text_MemberPoint.Text = "";
        Text_Phone.Text = "";
        Text_MemberCard.Text = "";
        Text_Discount.Text = "";
        Text_ShouyiID.Text = "";
    }

    //添加衣物
    protected void NewClothes_Click(object sender, EventArgs e)
    {
        CheckSession();
        DropDownList sname = (DropDownList)GridView1.FooterRow.FindControl("DropDownListSName");
        DropDownList cname = (DropDownList)GridView1.FooterRow.FindControl("DropDownListCName");
        DropDownList colorname = (DropDownList)GridView1.FooterRow.FindControl("DropDownListCColor");
        DropDownList brandname = (DropDownList)GridView1.FooterRow.FindControl("DropDownListCBrand");
        TextBox cAttach = (TextBox)GridView1.FooterRow.FindControl("C_Text_CAttachName");
        TextBox cBle = (TextBox)GridView1.FooterRow.FindControl("C_TextBox_BlemishName");
        TextBox aService = (TextBox)GridView1.FooterRow.FindControl("C_TextBox_AddService");
        TextBox aPrice = (TextBox)GridView1.FooterRow.FindControl("C_Text_AddPrice");
        DropDownList place1 = (DropDownList)GridView1.FooterRow.FindControl("DropDownListPlace1");
        TextBox count = (TextBox)GridView1.FooterRow.FindControl("C_Text_CNum");
        TextBox washPrice = (TextBox)GridView1.FooterRow.FindControl("C_Text_Price");
        TextBox disc = (TextBox)GridView1.FooterRow.FindControl("C_Text_Discount");
        TextBox tp = (TextBox)GridView1.FooterRow.FindControl("C_Text_TotalPrice");

        string sname3 = sname.SelectedValue.Trim().ToString();//服务类型
        string cname3 = cname.SelectedValue.Trim().ToString();//衣物名称
        string color3 = colorname.SelectedValue.Trim().ToString();//衣物颜色
        string brand3 = brandname.SelectedValue.Trim().ToString();//衣物品牌
        string attach = cAttach.Text.Trim().ToString(); //衣物附件
        string ble = cBle.Text.Trim().ToString(); //衣物瑕疵
        string addservice = aService.Text.Trim().ToString();//附加服务
        string addprice = aPrice.Text.Trim().ToString();//附加价格
        string place = place1.SelectedValue.Trim().ToString();//挂衣号
        string co = count.Text.Trim().ToString(); //数量
        string price = washPrice.Text.Trim().ToString();//单价
        string dis = disc.Text.Trim().ToString(); //折扣
        string tp3 = tp.Text.Trim().ToString(); //小计

        if (String.IsNullOrEmpty(sname3) || String.IsNullOrEmpty(cname3) || String.IsNullOrEmpty(co) || String.IsNullOrEmpty(price) || String.IsNullOrEmpty(dis) || String.IsNullOrEmpty(addprice) || String.IsNullOrEmpty(tp3))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "scriptadd", "<script>alert('不允许插入空值!');</script>");
        }
        else
        {
            string detailID = "D" + Common.GenerateUniqueID();
            string sql = "Insert into " + Session["tname"].ToString() + "(ShouyiDetailID,ClothesName,ServerName,ClothesColorName,ClothesBrandName,ClothesAttachmentName,ClothesBlemishName,AdditionalService,"
                 + "AdditionalPrice,PlaceNo,ClothesNumber,WashPrice,Discount,TotalPrice) values('" + detailID + "','" + cname3 + "','" + sname3 + "','" + color3 + "','" + brand3 + "','" 
                 + attach + "','" + ble + "','" + addservice + "'," + addprice + ",'" + place + "','" + co + "'," + price + "," + dis + "," + tp3  + ")";
            Common.ExecuteSql(sql);
            GridView1.DataBind();
            GridView1.PageIndex = GridView1.PageCount;
        }
    }

    //GridView1数据绑定
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        CheckSession();
        if ((e.Row.RowState & DataControlRowState.Edit) == DataControlRowState.Edit)
        {
            //设置只读属性,在RowEditing事件中无法设置
            ((TextBox)e.Row.FindControl("B_Text_TotalPrice")).Attributes.Add("readonly", "true");

            DropDownList colorname = (DropDownList)e.Row.FindControl("DropDownListCColor1");
            DropDownList brandname = (DropDownList)e.Row.FindControl("DropDownListCBrand1");
            DropDownList place1 = (DropDownList)e.Row.FindControl("DropDownListPlace2");
            string id = GridView1.DataKeys[e.Row.RowIndex].Value.ToString();


            string s1 = "Select ClothesColorName from ClothesColor";
            DataSet ds_color = Common.dataSet(s1);//获取颜色列表
            DataTable dt_color = ds_color.Tables[0];
            dt_color.Columns[0].Unique = true;
            dt_color.PrimaryKey = new DataColumn[] { dt_color.Columns[0] };//指定主键
            if (dt_color.Rows.Find("普通颜色") == null)
            {
                DataRow c1 = dt_color.NewRow();
                c1["ClothesColorName"] = "普通颜色";
                dt_color.Rows.Add(c1);
            }
            colorname.DataSourceID = null;
            colorname.DataSource = ds_color;
            colorname.DataTextField = "ClothesColorName";
            colorname.DataBind();
            string ss1 = "Select ClothesColorName from " + Session["tname"].ToString() + " where ShouyiDetailID='" + id + "'";
            string sss1 = Common.GetName(ss1, 0);//绑定颜色字段
            if (colorname.Items.FindByText(sss1) != null)
            {
                colorname.ClearSelection();
                colorname.SelectedValue = sss1;
            }


            string s2 = "Select ClothesBrandName from ClothesBrand";
            DataSet ds_brand = Common.dataSet(s2);//获取品牌列表
            DataTable dt_brand = ds_brand.Tables[0];
            dt_brand.Columns[0].Unique = true;
            dt_brand.PrimaryKey = new DataColumn[] { dt_brand.Columns[0] };//指定主键
            if (dt_brand.Rows.Find("普通品牌") == null)
            {
                DataRow c2 = dt_brand.NewRow();
                c2["ClothesBrandName"] = "普通品牌";
                dt_brand.Rows.Add(c2);
            }
            brandname.DataSourceID = null;
            brandname.DataSource = ds_brand;
            brandname.DataTextField = "ClothesBrandName";
            brandname.DataBind();
            string ss2 = "Select ClothesBrandName from " + Session["tname"].ToString() + " where ShouyiDetailID='" + id + "'";
            string sss2 = Common.GetName(ss2, 0);//绑定品牌字段
            if (brandname.Items.FindByText(sss2) != null)
            {
                brandname.ClearSelection();
                brandname.SelectedValue = sss2;
            }


            string s3 = "Select PlaceNo from PlaceNumber";
            DataSet ds_place = Common.dataSet(s3);//获取品牌列表
            DataTable dt_place = ds_place.Tables[0];
            dt_place.Columns[0].Unique = true;
            dt_place.PrimaryKey = new DataColumn[] { dt_place.Columns[0] };//指定主键
            if (dt_place.Rows.Find("不使用") == null)
            {
                DataRow c3 = dt_place.NewRow();
                c3["PlaceNo"] = "不使用";
                dt_place.Rows.Add(c3);
            }
            place1.DataSourceID = null;
            place1.DataSource = ds_place;
            place1.DataTextField = "PlaceNo";
            place1.DataBind();
            string ss3 = "Select PlaceNo from " + Session["tname"].ToString() + " where ShouyiDetailID='" + id + "'";
            string sss3 = Common.GetName(ss3, 0);//绑定挂衣号字段
            if (place1.Items.FindByText(sss3) != null)
            {
                place1.ClearSelection();
                place1.SelectedValue = sss3;
            }
        }
    }

    //更新“应收金额”
    protected void updateYingshou()
    {
        decimal su1;
        //这里应先检查临时表内是否有数据，否则报错
        string sm1 = "Select * from " + Session["tname"].ToString();
        DataSet dd1 = Common.dataSet(sm1);
        if (dd1.Tables[0].Rows.Count == 0)
        {
            su1 = 0;
        }
        else
        {
            string sum1 = "Select Sum(TotalPrice) from " + Session["tname"].ToString();
            su1 = Common.GetNameMoney(sum1, 0); 
        }

        decimal he = su1;
        D_Text_Yingshou.Text = he.ToString();
        D_Text_Card.Text = he.ToString();
        D_Text_Cash.Text = "0";
        D_Text_ReturnMoney.Text = "0";
        CheckBoxQF.Checked = false;
        ClientScript.RegisterStartupScript(ClientScript.GetType(), "myscriptgrid1update222", "<script>updateY()</script>");

        D_Text_Yingshou.Attributes.Add("readonly", "true");
        D_Text_ReturnMoney.Attributes.Add("readonly", "true");
    }

    //GridView1的编辑事件
    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        ClientScript.RegisterStartupScript(ClientScript.GetType(), "myscriptgrid1update", "<script>isNumber('B_Text_CNum','B_Text_Price','B_Text_Discount','B_Text_AddPrice','B_Text_TotalPrice','s1');</script>");
    }

    //收衣结单
    protected void OK_Click(object sender, EventArgs e)
    {
        CheckSession();
        string card = Text_MemberCard.Text.ToString();//会员卡号
        string state = Text_MemberState.Text.Trim().ToString();//会员状态
        string mima = D_Text_Mima.Text.Trim().ToString();//会员密码
        string smi = "Select MemberPassword from Member where MemberCard='" + card + "'";
        string mi = Common.GetName(smi, 0);
        string misql = "Select * from " + Session["tname"].ToString();//验证是否存在要收取的衣物
        DataSet ds = Common.dataSet(misql);
        bool isexist = false; //返回的数据集是否包含数据
        if (ds.Tables[0].Rows.Count != 0)
        {
            isexist = true;
        }
        if (isexist)
        {
            if (!String.IsNullOrEmpty(card))
            {
                if (state != "已挂失")
                {
                    if (mima == mi)
                    {
                        decimal yingshou = Convert.ToDecimal(D_Text_Yingshou.Text);//新增加的消费金额
                        decimal cardmoney = Convert.ToDecimal(Text_CardMoney.Text);//卡内余额

                        int jifen = readjifen();
                        int point = (int)(yingshou / jifen);//会员新增的积分

                        string shouyiID = Text_ShouyiID.Text.Trim().ToString();//收衣单号
                        string user = Session["uname"].ToString();//操作员
                        string bei = D_Text_Bei.Text.Trim().ToString();//简要备注
                        string date = DateTime.Now.ToString(); //收衣日期
                        string quyidate = Text_QuyiDate.Text.Trim().ToString(); //预计取衣日期
                        string qf = CheckBoxQF.Checked ? "是" : "否"; //是否取衣时再付款
                        decimal shishou = yingshou; //实收金额，先赋初值
                        decimal xianjin = Convert.ToDecimal(D_Text_Cash.Text);//现金付款
                        decimal cardfu = Convert.ToDecimal(D_Text_Card.Text);//会员卡付款
                        decimal returnMoney = Convert.ToDecimal(D_Text_ReturnMoney.Text);//找回金额
                        decimal cash = xianjin - returnMoney;
                        if (xianjin + cardfu >= yingshou)//实收金额
                        {
                            shishou = yingshou;
                        }
                        else
                        {
                            shishou = xianjin + cardfu;
                        }
                        //是否付款，如果只是支付了一部分，视为没有付款
                        string ispay = (shishou == yingshou) ? "是" : "否";
                        if (qf == "否")//现在要付款
                        {
                            if (ispay == "否")
                            {
                                ClientScript.RegisterStartupScript(this.GetType(), "shouyiscript3", "<script>alert('尚未付款或付款不足，无法完成收衣，你也可以选择取衣时再付款！')</script>");
                            }
                            else if (cardfu > cardmoney)
                            {
                                ClientScript.RegisterStartupScript(this.GetType(), "shouyiscript4", "<script>alert('会员卡余额不足,请选择现金付款或进行会员充值！')</script>");
                            }
                            else
                            {
                                string u_hui = "Update Member set CardMoney=CardMoney-" + cardfu + ",ConsumeMoney=ConsumeMoney+" + yingshou +
                                    ",ConsumeTimes=ConsumeTimes+1, MemberPoint=MemberPoint+" + point + ",RecentConsumeDate='" + date + "' where MemberCard='" + card + "'";
                                string u_shou = "Insert into Shouyi(ShouyiID,ShouyiDate,QuyiDate,Yingshou,Shishou,IsPay,MemberCard,UserName,Beizhu,CashMoney,CardMoney,PayDate) values('"
                                    + shouyiID + "','" + date + "','" + quyidate + "'," + yingshou + "," + shishou + ",'" + ispay + "','" + card + "','" + user + "','" + bei + "'," + cash + "," + cardfu + ",'" + DateTime.Now.ToString() + "')";
                                shouyisql(u_hui, u_shou, shouyiID);
                            }
                        }
                        else //暂不付款
                        {
                            string u_hui1 = "Update Member set RecentConsumeDate='" + date + "' where MemberCard='" + card + "'";
                            string u_shou1 = "Insert into Shouyi(ShouyiID,ShouyiDate,QuyiDate,Yingshou,Shishou,IsPay,MemberCard,UserName,Beizhu,CashMoney,CardMoney) values('"
                                + shouyiID + "','" + date + "','" + quyidate + "'," + yingshou + "," + shishou + ",'" + ispay + "','" + card + "','" + user + "','" + bei + "',0,0)";
                            shouyisql(u_hui1, u_shou1, shouyiID);
                        }
                    }
                    else
                    {
                        ClientScript.RegisterStartupScript(this.GetType(), "shouyiscript7", "<script>alert('输入的密码不正确，无法收取衣物，请先修改会员资料!')</script>");
                    }
                }
                else
                {
                    ClientScript.RegisterStartupScript(this.GetType(), "shouyiscript5", "<script>alert('当前会员已挂失，无法收取衣物，请先修改会员资料!')</script>");
                }
            }
            else
            {
                ClientScript.RegisterStartupScript(this.GetType(), "shouyiscript2", "<script>alert('不存在会员信息，请先查询出会员信息!')</script>");
            }
        }
        else
        {
            ClientScript.RegisterStartupScript(this.GetType(), "shouyiscript1", "<script>alert('不存在要收取的衣物，请先添加衣物!')</script>");
        }
    }

    //收衣Sql操作,更新会员表、收衣表、详细收衣表,清空临时表
    protected void shouyisql(string e, string f, string syid)
    {
        string connectionStr = ConfigurationManager.ConnectionStrings["SqlConnection1"].ConnectionString;
        SqlTransaction transaction = null;
        using (SqlConnection conn = new SqlConnection(connectionStr))
        {
            conn.Open();
            try
            {
                //调用SqlConnection的BeginTransaction方法开启一个事务，并返回已经开启的事务
                transaction = conn.BeginTransaction();
                SqlCommand cmd = new SqlCommand();
                cmd.Connection = conn;

                //需要指定要添加到事务中去的SqlCommand对象
                cmd.Transaction = transaction;
                cmd.CommandText = e;//更新会员表
                cmd.ExecuteNonQuery();
                cmd.CommandText = f;//写入收衣表
                cmd.ExecuteNonQuery();

                string q1 = "Select * from " + Session["tname"].ToString();
                DataSet shouyi_detail = Common.dataSet(q1);
                DataTableReader detail = shouyi_detail.CreateDataReader();
                if (detail.HasRows)//读取临时表，写入详细收衣表
                {
                    while (detail.Read())
                    {
                        string detailID = detail.GetString(0);//详细编号
                        string servername = detail.GetString(2);//服务类型名
                        string clothesname = detail.GetString(1);//衣物名
                        string find = "select ClothesID from Clothes where ServerName='" + servername + "' and ClothesName='" + clothesname + "'";
                        string clothesid = Common.GetName(find, 0);//衣物ID
                        string color = detail.GetString(3);//衣物颜色
                        string brand = detail.GetString(4);//衣物品牌
                        string attach = detail.GetString(5);//衣物附件
                        string blemish = detail.GetString(6);//衣物瑕疵
                        string addservice = detail.GetString(7);//附加服务
                        decimal addprice = detail.GetDecimal(8);//附加价格
                        string place = detail.GetString(9);//挂衣号
                        int num = detail.GetInt32(10);//衣物数量
                        decimal price = detail.GetDecimal(11);//衣物单价
                        double discount = detail.GetDouble(12);//衣物折扣,不能用float，数据库中只有double
                        decimal totalprice = detail.GetDecimal(13);//小计

                        string detailsq = "Insert into ShouyiDetail(ShouyiDetailID,ShouyiID,ClothesID,ClothesBrandName,ClothesColorName,ClothesAttachmentName,ClothesBlemishName,AdditionalService,AdditionalPrice,PlaceNo,ClothesNumber,WashPrice,Discount,TotalPrice,IsTaken,IsChongxi,IsPei,Beizhu) values('"
                            + detailID + "','" + syid + "','" + clothesid + "','" + brand + "','" + color + "','" + attach + "','" + blemish + "','" + addservice + "'," + addprice + ",'" + place + "','" + num + "'," + price + "," + discount + "," + totalprice + ",'否','否','否',' ')";
                        cmd.CommandText = detailsq;
                        cmd.ExecuteNonQuery();
                    }
                }
                detail.Close();

                //清空临时表
                string u_clear1 = "Delete from " + Session["tname"].ToString();
                cmd.CommandText = u_clear1;
                cmd.ExecuteNonQuery();

                //提交事务，修改将回到数据库中
                transaction.Commit();
                ClientScript.RegisterStartupScript(this.GetType(), "shouyishouyi", "<script>alert('收衣成功!');</script>");
                GridView1.DataBind();
                Search_Click(null, null);
                D_Text_Bei.Text = "";
            }
            catch (Exception ex)
            {
                //回滚事务
                transaction.Rollback();
                throw ex;
            }
            finally
            {
                conn.Close();
            }
        }
    }
}