﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPage.master" ValidateRequest="false" AutoEventWireup="true" CodeFile="Memo.aspx.cs" Inherits="Tongji_Memo" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">

<script type="text/javascript">
    $(document).ready(function () {
        $("#<%= messagetxt.ClientID %>").xheditor({ tools: 'Cut,Copy,Paste,Pastetext,|,FontSize,Fontface,Bold,Italic,Underline,Strikethrough,FontColor,Hr,BackColor,Align,Outdent,Indent,Blocktag,Fullscreen,About' });
    });
</script>

<script type="text/javascript">

    var lastRowSelected;
    var originalColor;

    //单击GridView行，先触发一个按钮的的点击事件，调用后台函数
    function GridView1_RowClick(ID) {
        var hdn = document.getElementById("<%=hdnID.ClientID %>");
        hdn.value = ID;
        document.getElementById("<%=ClickID.ClientID %>").click();
    }

    //初始化函数
    window.onload = function () {
        HdnInit();
        GridView1_Color();
    }

    function GridView1_mouseHover(row) {
        row.style.cursor = 'pointer';
    }

    //页面加载时，自动点击第一行,已经由后台代码初始化，否则会出现两次闪烁
    function HdnInit() {
        var hdn = document.getElementById("<%=hdnID.ClientID %>");
        var allRows = document.getElementById("<%=GridView1.ClientID %>").getElementsByTagName("tr");
        if (allRows.length > 1) {
            if (hdn.value == "HIDDEN_DEFAULT_VALUE") {
                hdn.value = allRows[0].cells[0].innerText;
            }
        }
        else {
            hdn.value = "HIDDEN_DEFAULT_VALUE";
        }
    }

    //单击GridView行，颜色变化
    function GridView1_Color() {
        var hdn = document.getElementById("<%=hdnID.ClientID %>");
        var allRows = document.getElementById("<%=GridView1.ClientID %>").getElementsByTagName("tr");
        for (var i = 0; i < allRows.length; i++) {
            if (allRows[i].cells[0].innerText.indexOf(hdn.value) != -1) {
                if (lastRowSelected != allRows[i]) {
                    if (lastRowSelected != null) {
                        lastRowSelected.style.backgroundColor = originalColor;
                        lastRowSelected.style.color = 'Black'
                        lastRowSelected.style.fontWeight = 'normal';
                    }
                    originalColor = allRows[i].style.backgroundColor;
                    allRows[i].style.backgroundColor = '#DAE7F2';
                    allRows[i].style.color = 'black';
                    allRows[i].style.fontWeight = 'normal';
                    lastRowSelected = allRows[i];
                }
            }
        }
    }

    //保存便笺
    function save() {
        var minfotitle = document.getElementById("<%= MemoTitle.ClientID %>");
        var mtitle = jQuery.trim(minfotitle.value);
        var messagetxt = $("#<%= messagetxt.ClientID %>").val();
        var mtxt = jQuery.trim(messagetxt);

        var minfo = document.getElementById("<%= minfo.ClientID %>");
        if (mtitle == "") {
            alert("错误，标题不能为空!");
            return;
        }
        else if (mtitle.length > 20) {
            alert("错误，标题过长！");
            return;
        }
        else if (mtxt.length > 900) {
            alert("错误，输入字符串过多，注意这不是小说！");
            return;
        }
        else {
            minfo.value = mtxt;
            document.getElementById("<%= SaveButton.ClientID %>").click();
        }
    }
</script>

<!--用于触发行的单击事件-->
<asp:Button ID="ClickID" runat="server" OnClick="ClickBound" CssClass="visiblenone" />

<!--保存ID-->
<input id="hdnID" type="hidden" value="HIDDEN_DEFAULT_VALUE" runat="server" name="hdnID" />

<!--要保存的信息-->
<input id="minfo" type="hidden" value="" runat="server" name="minfo" />

<!--触发提交事件-->
<asp:Button ID="SaveButton" runat="server" onclick="SaveButton_Click" CssClass="visiblenone" />

<div style="overflow-y:scroll;float:left;width:20%;height:510px;margin-top:1px;background-color:#F5F6F7;">
    <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" 
        DataKeyNames="MemoID" DataSourceID="SqlDataSource1" Width="100%"
        EnableModelValidation="True" CellPadding="4" CssClass="grid1"
        GridLines="None" onrowdatabound="GridView1_RowDataBound" 
        onprerender="GridView1_PreRender" ShowHeader="false" >
        <Columns>
            <asp:BoundField DataField="MemoID" HeaderText="" ShowHeader="false"
                SortExpression="MemoID" ItemStyle-CssClass="visiblenone" 
                HeaderStyle-CssClass="visiblenone"
                />
            <asp:BoundField DataField="MemoTitle" HeaderText=""
                SortExpression="MemoTitle" />
        </Columns>
    </asp:GridView>
    <asp:SqlDataSource ID="SqlDataSource1" runat="server" 
        ConnectionString="<%$ ConnectionStrings:SqlConnection1 %>" 
        SelectCommand="SELECT [MemoID], [MemoTitle] FROM [Memo]"></asp:SqlDataSource>
</div>

<div style="margin-bottom:5px;float:left;width:80%;height:500px;">
    <a style="color:Green;width:10%">&nbsp;便笺标题：</a>
    <asp:TextBox ID="MemoTitle" runat="server" Width="40%" CssClass="tx-big"></asp:TextBox>
    <a style="color:Green;width:10%">&nbsp;&nbsp;&nbsp;创建者：</a>
    <asp:Label ID="MemoUser" runat="server" />
    <asp:Button ID="DelButton" runat="server" Text="删除" CssClass="btn-warning-float" 
        onclick="DelButton_Click" />
    <asp:Button ID="AddButton" runat="server" Text="新建" CssClass="btn-info-float-b" 
        onclick="AddButton_Click" />
    <input type="button" id="sbutton" name="sbutton" value="保存" 
        onclick="save();" class="btn-success-float-b" />
    <textarea ID="messagetxt" runat="server" 
        rows="30" cols="5" style="width:100%;"></textarea>
</div>

</asp:Content>

