﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Tongji_Memo : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        ClientScript.RegisterStartupScript(ClientScript.GetType(), "myscript", "<script>clickmenu(3);</script>");
    }

    protected void CheckSession()
    {
        if (Session["uname"] == null)
        {
            Response.Redirect("../Login.aspx");
        }
    }

    //在GridView1中点击不同的行
    protected void ClickBound(object sender, EventArgs e)
    {
        CheckSession();
        string sql = "select * from Memo where MemoID='" + hdnID.Value + "'";
        DataSet dset = Common.dataSet(sql);
        DataRow drow = dset.Tables[0].Rows[0];
        int count = dset.Tables[0].Rows.Count;
        if (count > 0)
        {
            MemoTitle.Text = drow["MemoTitle"].ToString();
            MemoUser.Text = drow["UserName"].ToString();
            messagetxt.InnerText = drow["MemoInfo"].ToString();
        }
    }

    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        CheckSession();
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.ID = GridView1.DataKeys[e.Row.RowIndex].Value.ToString();
            e.Row.Attributes.Add("onclick",
                "GridView1_RowClick('" + e.Row.ID + "')");
            e.Row.Attributes.Add("onmouseover", "GridView1_mouseHover(this)");
        }
    }

    protected void GridView1_PreRender(object sender, EventArgs e)
    {
        CheckSession();
        if (GridView1.Rows.Count > 0)
        {
            if (hdnID.Value == "HIDDEN_DEFAULT_VALUE")
            {
                string sql = "select * from Memo";
                DataSet dset = Common.dataSet(sql);
                DataRow drow = dset.Tables[0].Rows[0];
                int count = dset.Tables[0].Rows.Count;
                if (count > 0)
                {
                    MemoTitle.Text = drow["MemoTitle"].ToString();
                    MemoUser.Text = drow["UserName"].ToString();
                    messagetxt.InnerText = drow["MemoInfo"].ToString();
                }
            }
        }
    }

    //新建默认便笺
    protected void AddButton_Click(object sender, EventArgs e)
    {
        CheckSession();
        string cuser = Session["uname"].ToString();
        string id = "M" + Common.GenerateUniqueID();
        string sql = "insert into [Memo](MemoID,MemoTitle,UserName,MemoInfo,MemoDate) values('" 
            + id + "','新便笺','" + cuser + "','','" + DateTime.Now.ToString() + "')";
        Common.ExecuteSql(sql);
        hdnID.Value = id;
        GridView1.DataBind();
        MemoTitle.Text = "新便笺";
        MemoUser.Text = cuser;
        messagetxt.InnerText = "";
    }

    //保存便笺
    protected void SaveButton_Click(object sender, EventArgs e)
    {
        CheckSession();
        string memoinfo = minfo.Value;
        string sql = "update [Memo] set MemoTitle='" + MemoTitle.Text.ToString()
            + "', MemoInfo='" + memoinfo + "' where MemoID='" + hdnID.Value + "'";
        Common.ExecuteSql(sql);
        GridView1.DataBind();
    }

    //删除便笺
    protected void DelButton_Click(object sender, EventArgs e)
    {
        CheckSession();
        string sql = "delete from [Memo] where MemoID='" + hdnID.Value + "'";
        Common.ExecuteSql(sql);
        hdnID.Value = "HIDDEN_DEFAULT_VALUE";
        GridView1.DataBind();

        if (GridView1.Rows.Count == 0)
        {
            AddButton_Click(sender,e);
        }
    }
}