﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" ValidateRequest="false" CodeFile="Message.aspx.cs" Inherits="Tongji_Message" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">

<script type="text/javascript">

    var lastRowSelected;
    var originalColor;

    //初始化函数
    window.onload = function () {
        TextEditorInit();
        HdnInit();
        GridView1_Color();
        InfoInit();
    }

    function TextEditorInit() {
        $("#<%= messagetxt.ClientID %>").xheditor({ tools: 'Cut,Copy,Paste,Pastetext,|,FontSize,Fontface,Bold,Italic,Underline,Strikethrough,FontColor,Hr,BackColor,Align,Outdent,Indent,Blocktag,Fullscreen,About' });
    }

    //显示留言内容
    function InfoInit() {
        var minfo = document.getElementById("<%= minfo.ClientID %>");
        var messageinfo = document.getElementById("messageinfo");
        messageinfo.innerHTML = minfo.value;
        $("#messageinfo").show("slow");
    }

    function GridView1_mouseHover(row) {
        row.style.cursor = 'pointer';
    }

    //单击GridView行，先触发一个按钮的的点击事件，调用后台函数
    function GridView1_RowClick(ID) {
        var hdn = document.getElementById("<%=hdnID.ClientID %>");
        hdn.value = ID;
        document.getElementById("<%=ClickID.ClientID %>").click();
    }

    //页面加载时，自动点击第一行,已经由后台代码初始化，否则会出现两次闪烁
    function HdnInit() {
        var hdn = document.getElementById("<%=hdnID.ClientID %>");
        var allRows = document.getElementById("<%=GridView1.ClientID %>").getElementsByTagName("tr");
        if (allRows.length > 1) {
            if (hdn.value == "HIDDEN_DEFAULT_VALUE") {
                hdn.value = allRows[1].cells[0].innerText;
            }
        }
        else {
            hdn.value = "HIDDEN_DEFAULT_VALUE";
        }
    }

    //单击GridView行，颜色变化
    function GridView1_Color() {
        var hdn = document.getElementById("<%=hdnID.ClientID %>");
        var allRows = document.getElementById("<%=GridView1.ClientID %>").getElementsByTagName("tr");
        for (var i = 0; i < allRows.length; i++) {
            if (allRows[i].cells[0].innerText.indexOf(hdn.value) != -1) {
                if (lastRowSelected != allRows[i]) {
                    if (lastRowSelected != null) {
                        lastRowSelected.style.backgroundColor = originalColor;
                        lastRowSelected.style.color = 'Black'
                        lastRowSelected.style.fontWeight = 'normal';
                    }
                    originalColor = allRows[i].style.backgroundColor;
                    allRows[i].style.backgroundColor = '#0099CC';
                    allRows[i].style.color = 'White';
                    allRows[i].style.fontWeight = 'normal';
                    lastRowSelected = allRows[i];
                }
            }
        }
    }

    //添加留言
    function AddNewMessage() {
        var leaverName = document.getElementById("<%= LeaverName.ClientID %>");
        var leaverPhone = document.getElementById("<%= LeaverPhone.ClientID %>");
        var lName = jQuery.trim(leaverName.value);
        var lPhone = jQuery.trim(leaverPhone.value);

        var leaverMessage = $("#<%= messagetxt.ClientID %>").val();
        var message = jQuery.trim(leaverMessage);

        if (lName == "" | lPhone == "" | message == "") {
            alert("错误，存在没有填写的内容!");
        }
        else if (message.length > 1000) {
            alert("错误，输入字符串过多，注意这是留言不是小说！");
        }
        else {
            document.getElementById("<%= AddNewMessageButton.ClientID %>").click();
        }
    }
</script>

<div class="he3" style="background-color:#666666">
    <a style="font-size:20px;color:White;">留言薄</a>
    <asp:Button ID="ClearButton" runat="server" Text="清空留言" 
        CssClass="btn-small-float" onclick="ClearButton_Click" />
    <asp:Button ID="search" runat="server" Text="查询" OnClick="Search_Click" CssClass="btn-small-float" />
    <asp:TextBox ID="keyword" runat="server" CssClass="he2"></asp:TextBox> 
</div>

<!--具体留言信息-->
<input id="minfo" type="hidden" value="" runat="server" name="minfo" />

<!--留言ID-->
<input id="hdnID" type="hidden" value="HIDDEN_DEFAULT_VALUE" runat="server" name="hdnID" />

<!--用于触发行的单击事件-->
<asp:Button ID="ClickID" runat="server" OnClick="ClickBound" CssClass="visiblenone" />

<!--触发提交事件-->
<asp:Button ID="AddNewMessageButton" runat="server" onclick="AddNewMessage_Click" CssClass="visiblenone" />

<div style="clear:both; width:100%; height:175px;">
    <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" 
        Width="100%" PagerStyle-CssClass="pager" PageSize="5"
        EnableModelValidation="True" AllowPaging="True" AllowSorting="True"
        CssClass="grid1" DataSourceID="SqlDataSource1" DataKeyNames="MessageID" 
        onrowdatabound="GridView1_RowDataBound" onprerender="GridView1_PreRender"
        >
        <Columns>
            <asp:BoundField DataField="MessageID" HeaderText="留言编号" 
                InsertVisible="False" ReadOnly="True" SortExpression="MessageID" />
            <asp:BoundField DataField="MessageLeaver" HeaderText="留言者" 
                SortExpression="MessageLeaver" />
            <asp:BoundField DataField="Phone" HeaderText="联系电话" 
                SortExpression="Phone" />
            <asp:BoundField DataField="MessageDate" HeaderText="留言日期" 
                SortExpression="MessageDate" />
        </Columns>
    </asp:GridView>
    <asp:SqlDataSource ID="SqlDataSource1" runat="server" 
        ConnectionString="<%$ ConnectionStrings:SqlConnection1 %>" 
        SelectCommand="SELECT * FROM [Message]">
    </asp:SqlDataSource>
</div>


<div id="effect" style="overflow:scroll; clear:both; width:100%; height:140px;">
    <label id="messageinfo" style="display:none"></label>
</div>

<asp:Button ID="AddNewButton" runat="server" Text="添加新留言" Visible="false" CssClass="btn-small" />
<div class="he3" style="background-color:#F0F0EE">
    <table>
        <tr>
            <td>
                留言者：<asp:TextBox ID="LeaverName" MaxLength="20" runat="server" /></td>
            <td>
                联系电话：<asp:TextBox ID="LeaverPhone" MaxLength="20" runat="server" /></td>
            <td>
               <input type="submit" id="addnew" name="addnew" value="添加新留言" onclick="AddNewMessage();" class="btn-small" /></td>
        </tr>
    </table>
</div>

<div>
    <textarea ID="messagetxt" runat="server" 
        rows="7" cols="5" style="width:100%"></textarea>
</div>

</asp:Content>

