﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Tongji_Message : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        this.keyword.Attributes.Add("onkeydown", "if(event.keyCode==13){document.all." + this.search.ClientID + ".click();}");
        ClientScript.RegisterStartupScript(ClientScript.GetType(), "myscript", "<script>clickmenu(3);</script>");
    }

    protected void CheckSession()
    {
        if (Session["uname"] == null)
        {
            Response.Redirect("../Login.aspx");
        }
    }

    //查询
    protected void Search_Click(object sender, EventArgs e)
    {
        CheckSession();
        string key = keyword.Text.Trim().ToString();
        if (!String.IsNullOrEmpty(key))
        {
            string sql = "Select * from [Message] where [MessageLeaver] like '%" + key
                + "%' or [Phone] like '%" + key + "%'";
            SqlDataSource1.SelectCommand = sql;
            Session["Message"] = sql;
            GridView1.DataBind();
            this.Page.SetFocus(keyword);
        }
        else
        {
            Session["Message"] = null;
            SqlDataSource1.SelectCommand = "SELECT * FROM [Message]";
            GridView1.DataBind();
            this.Page.SetFocus(keyword);
        }
    }

    //在GridView1中点击不同的行
    protected void ClickBound(object sender, EventArgs e)
    {
        CheckSession();
        string sql = "select [MessageInfo] from Message where MessageID='" + hdnID.Value + "'";
        minfo.Value = Common.GetName(sql, 0);
    }

    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        CheckSession();
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.ID = e.Row.Cells[0].Text;
            e.Row.Attributes.Add("onclick",
                "GridView1_RowClick('" + e.Row.Cells[0].Text + "')");
            e.Row.Attributes.Add("onmouseover", "GridView1_mouseHover(this)");
        }
    }

    protected void GridView1_PreRender(object sender, EventArgs e)
    {
        CheckSession();
        if (GridView1.Rows.Count > 0)
        {
            if (hdnID.Value == "HIDDEN_DEFAULT_VALUE")
            {
                string sql = "select [MessageInfo] from Message";
                DataSet dset = Common.dataSet(sql);
                DataRow drow = dset.Tables[0].Rows[0];
                int count = dset.Tables[0].Rows.Count;
                if (count > 0)
                {
                    minfo.Value = drow["MessageInfo"].ToString();
                }
            }
        }
    }

    //添加新留言
    protected void AddNewMessage_Click(object sender, EventArgs e)
    {
        CheckSession();
        string leaverN = LeaverName.Text.Trim().ToString();
        string leaverP = LeaverPhone.Text.Trim().ToString();
        string message = messagetxt.InnerText;
        if (String.IsNullOrEmpty(leaverN) || String.IsNullOrEmpty(leaverP) || String.IsNullOrEmpty(message))
        {
            ClientScript.RegisterStartupScript(ClientScript.GetType(), "addscript",
                "<script>alert('不允许为空！');</script>");
        }
        else
        {
            string id = "L" + Common.GenerateUniqueID();
            string sql = "insert into Message(MessageID,MessageLeaver,Phone,MessageInfo,MessageDate) values('"
                + id + "','" + leaverN + "','" + leaverP + "','" + message + "','" + DateTime.Now.ToString() + "')";
            Common.ExecuteSql(sql);
            LeaverName.Text = "";
            LeaverPhone.Text = "";
            messagetxt.InnerText = "";
            GridView1.DataBind();
        }
    }

    //清空留言
    protected void ClearButton_Click(object sender, EventArgs e)
    {
        CheckSession();
        string current_user = Session["uname"].ToString();
        string s1 = "Select UserType from [User] where UserName='" + current_user + "'";
        string current_type = Common.GetName(s1, 0);
        if (current_type != "管理员")
        {
            ClientScript.RegisterStartupScript(ClientScript.GetType(), "clearscript",
                "<script>alert('权限不足！');</script>");
            return;
        }
        string delete = "delete from [Message]";
        Common.ExecuteSql(delete);
        GridView1.DataBind();
    }
}