﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Shouru.aspx.cs" Inherits="Tongji_Shouru" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">

<script type="text/javascript">
    $(function () {
        $("#shouru-tabs").tabs();

        $('#shouru-graph').highcharts({
            chart: {
                type: 'column',
                marginRight:70
            },
            title: {
                text: ''
            },
            subtitle: {
                text: ''
            },
            xAxis: {
                categories:<%=shouru_tab1_x %>,
                labels:{
                    style:{
                        fontSize:'14px'
                    }
                }
            },
            yAxis: {
                min: 0,
                title: {
                    text: '金额 (元)',
                    style:{
                        fontSize:'14px'
                    },
                    margin: 30
                }
            },
            legend:{
                align:'center'
            },
            tooltip: {
                headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
                pointFormat: '<tr><td style="color:{series.color};padding:0"></td>' +
                    '<td style="padding:0"><b>{point.y:.2f} 元</b></td></tr>',
                footerFormat: '</table>',
                shared: true,
                useHTML: true
            },
            plotOptions: {
                column: {
                    pointPadding: 0.2,
                    borderWidth: 0
                }
            },
            series:<%= shouru_tab1_y %>
        });


        $('#server-graph').highcharts({
            chart: {
                type: 'column',
                marginRight:70
            },
            title: {
                text: ''
            },
            subtitle: {
                text: ''
            },
            xAxis: {
                categories:<%=server_tab2_x %>,
                labels:{
                    style:{
                        fontSize:'14px'
                    }
                }
            },
            yAxis: {
                min: 0,
                title: {
                    text: '金额 (元)',
                    style:{
                        fontSize:'14px'
                    },
                    margin: 30
                }
            },
            legend:{
                align:'center'
            },
            tooltip: {
                headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
                pointFormat: '<tr><td style="color:{series.color};padding:0"></td>' +
                    '<td style="padding:0"><b>{point.y:.2f} 元</b></td></tr>',
                footerFormat: '</table>',
                shared: true,
                useHTML: true
            },
            plotOptions: {
                column: {
                    pointPadding: 0.2,
                    borderWidth: 0
                }
            },
            series:<%=server_tab2_y %>
        });


        $('#day-graph').highcharts({
            chart: {
                type: 'spline',
                marginRight: 60
            },
            title: {
                text: ''
            },
            subtitle: {
                text: ''
            },
            xAxis: {
                categories: [<%=day_tab3_x %>]
            },
            yAxis: {
                title: {
                    text: '金额（元）',
                    margin: 30
                },
                style:{
                    fontSize:'14px'
                },
                labels: {
                    formatter: function() {
                        return this.value
                    }
                }
            },
            tooltip: {
                crosshairs: true,
                shared: true,
                pointFormat: '<tr><td style="color:{series.color};padding:0"></td>' +
                    '<td style="padding:0"><b>{point.y:.2f} 元</b></td></tr>'
            },
            plotOptions: {
                spline: {
                    marker: {
                        radius: 4,
                        lineColor: '#666666',
                        lineWidth: 1
                    }
                }
            },
            series: [{
                name: '日期',
                marker: 
                {
                    symbol: 'circle'
                },
                data: [<%=day_tab3_y %>]
            }]
        });

        $('#month-graph').highcharts({
            chart: {
                type: 'bar',
                marginRight:50
            },
            title: {
                text: ''
            },
            subtitle: {
                text: ''
            },
            xAxis: {
                categories: [<%=month_tab4_x %>],
                title: {
                    text: null
                }
            },
            yAxis: {
                min: 0,
                title: {
                    text: '金额 (元)',
                    align: 'high'
                },
                labels: {
                    overflow: 'justify'
                }
            },
            tooltip: {
                pointFormat: '<tr><td style="color:{series.color};padding:0"></td>' +
                    '<td style="padding:0"><b>{point.y:.2f} 元</b></td></tr>'
            },
            plotOptions: {
                bar: {
                    dataLabels: {
                        enabled: true
                    }
                }
            },
            legend: {
                layout: 'vertical',
                align: 'left',
                verticalAlign: 'top',
                x: 0,
                y: 0,
                floating: true,
                borderWidth: 1,
                backgroundColor: '#FFFFFF',
                shadow: true
            },
            credits: {
                enabled: false
            },
            series: [{
                name: '月份',
                data: [<%=month_tab4_y %>]
            }]
        });

        $('#year-graph').highcharts({
            chart: {
                type: 'column',
                marginRight:60
            },
            title: {
                text: ''
            },
            subtitle: {
                text: ''
            },
            xAxis: {
                categories:[<%=year_tab5_x %>],
                labels:{
                    style:{
                        fontSize:'14px'
                    }
                }
            },
            yAxis: {
                min: 0,
                title: {
                    text: '金额 (元)',
                    style:{
                        fontSize:'14px'
                    },
                    margin: 30
                }
            },
            legend:{
                align:'center'
            },
            tooltip: {
                headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
                pointFormat: '<tr><td style="color:{series.color};padding:0"></td>' +
                    '<td style="padding:0"><b>{point.y:.2f} 元</b></td></tr>',
                footerFormat: '</table>',
                shared: true,
                useHTML: true
            },
            plotOptions: {
                column: {
                    pointPadding: 0.2,
                    borderWidth: 0
                }
            },
            series: [{
                name: '年份',
                data: [<%=year_tab5_y %>]
            }]
        });

    });

    function CheckList() {
        $("#shouru-graph").css("display", "none");
        $("#shouru-list").css("display", "block");

        $("#server-graph").css("display", "none");
        $("#server-list").css("display", "block");

        $("#day-graph").css("display", "none");
        $("#day-list").css("display", "block");

        $("#month-graph").css("display", "none");
        $("#month-list").css("display", "block");

        $("#year-graph").css("display", "none");
        $("#year-list").css("display", "block");
    }

    function CheckGraph() {
        $("#shouru-graph").css("display", "block");
        $("#shouru-list").css("display", "none");

        $("#server-graph").css("display", "block");
        $("#server-list").css("display", "none");

        $("#day-graph").css("display", "block");
        $("#day-list").css("display", "none");

        $("#month-graph").css("display", "block");
        $("#month-list").css("display", "none");

        $("#year-graph").css("display", "block");
        $("#year-list").css("display", "none");
    }

    //分析
    function fenxi()
    {
        document.getElementById("<%= FenxiButton.ClientID %>").click();
    }
</script>

<script language="javascript" type="text/javascript">
    //jqueryUI日期选择
    $(function () {
        $("#<%= FromText.ClientID %>").datepicker({});
        $("#<%= ToText.ClientID %>").datepicker({});
        $("#ui-datepicker-div").css('font-size', '0.7em') //改变大小
    });
</script>

<asp:Button ID="FenxiButton" runat="server" onclick="FenxiButton_Click" CssClass="visiblenone" />

<div id="shouru-tabs">
  <ul>
    <li><a style="font-size:12px;" href="#tabs-1">总体收入分析</a></li>
    <li><a style="font-size:12px" href="#tabs-2">按洗衣类型分析</a></li>
    <li><a style="font-size:12px" href="#tabs-3">按日分析收入</a></li>
    <li><a style="font-size:12px" href="#tabs-4">按月分析收入</a></li>
    <li><a style="font-size:12px" href="#tabs-5">按年分析收入</a></li>

    <li><a style="font-size:14px;font-weight:normal;"></a></li>
    <li><a style="font-size:14px;font-weight:normal;cursor:default;">从</a></li>
    <li><asp:TextBox ID="FromText" Font-Size="14px" Width="90px" runat="server" /></li>
    <li><a style="font-size:14px;font-weight:normal;cursor:default;">到</a></li>
    <li><asp:TextBox ID="ToText" Font-Size="14px" Width="90px" runat="server" /></li>
    <li><input type="button" id="fenxi_button" name="fenxi_button" onclick="fenxi();"
        style="font-size:14px;margin-left:10px;background: #E6E6E6;" value="分析" /></li>
    <li style="float:right;">
        <div class="scontainer">
        <div class="switch">
          <input type="radio" class="switch-input" onclick="CheckList();" name="view" value="列表" id="week" checked="checked" />
          <label for="week" class="switch-label switch-label-off">列表</label>
          <input type="radio" class="switch-input" onclick="CheckGraph();" name="view" value="图表" id="month" />
          <label for="month" class="switch-label switch-label-on">图表</label>
          <span class="switch-selection"></span>
        </div>
        </div>
    </li>
  </ul>

  <div id="tabs-1" style="height:430px;">
    <div id="shouru-list" style="text-align:center;width:90%;margin:60px auto 0 auto;">
        <asp:GridView ID="GridView1" runat="server" Width="100%" Height="100%" >
        </asp:GridView>
    </div>
    <div id="shouru-graph" style="display:none;height:430px;width:80%; margin:0 auto 0 auto;"></div>
  </div>

  <div id="tabs-2" style="height:430px;">
    <div id="server-list" style="text-align:center;width:90%;margin:60px auto 0 auto;">
        <asp:GridView ID="GridView2" runat="server" Width="100%" Height="100%">
        </asp:GridView>
    </div>
    <div id="server-graph" style="display:none;height:430px;width:80%; margin:0 auto 0 auto;"></div>
  </div>

  <div id="tabs-3" style="height:430px;">
    <div id="day-list" style="text-align:center;width:90%;margin:60px auto 0 auto;">
        <asp:GridView ID="GridView3" runat="server" Width="100%" Height="100%">
        </asp:GridView>
    </div>
    <div id="day-graph" style="display:none;height:430px;width:90%; margin:0 auto 0 auto;"></div>
  </div>

  <div id="tabs-4" style="height:430px;">
    <div id="month-list" style="text-align:center;width:90%;margin:60px auto 0 auto;">
        <asp:GridView ID="GridView4" runat="server" Width="100%" Height="100%">
        </asp:GridView>
    </div>
    <div id="month-graph" style="display:none;height:430px;width:90%; margin:0 auto 0 auto;"></div>
  </div>

  <div id="tabs-5" style="height:430px;">
    <div id="year-list" style="text-align:center;width:90%;margin:60px auto 0 auto;">
        <asp:GridView ID="GridView5" runat="server" Width="100%" Height="100%">
        </asp:GridView>
    </div>
    <div id="year-graph" style="display:none;height:430px;width:90%; margin:0 auto 0 auto;"></div>
  </div>

</div>

</asp:Content>

