﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Data;

public partial class Tongji_Shouru : System.Web.UI.Page
{
    //总体收入，用于图表显示
    public string shouru_tab1_x = "";
    public string shouru_tab1_y = "";

    //洗衣类型，用于图表显示
    public string server_tab2_x = "";
    public string server_tab2_y = "";

    //按日分析，用于图表显示
    public string day_tab3_x = "";
    public string day_tab3_y = "";

    //按月分析，用于图表显示
    public string month_tab4_x = "";
    public string month_tab4_y = "";

    //按年分析，用于图表显示
    public string year_tab5_x = "";
    public string year_tab5_y = "";

    protected void Page_Load(object sender, EventArgs e)
    {
        ClientScript.RegisterStartupScript(ClientScript.GetType(), "myscript", "<script>clickmenu(3);</script>");
        FromText.Attributes.Add("readonly", "true");
        ToText.Attributes.Add("readonly", "true");
        if (!Page.IsPostBack)
        {
            string toDate = DateTime.Now.ToShortDateString();
            string fromDate = DateTime.Now.AddDays(-30).ToShortDateString();
            FromText.Text = fromDate;
            ToText.Text = toDate;

            Shouru(fromDate, toDate);
            ServerType(fromDate, toDate);
            DayAnalysis(fromDate, toDate);
            MonthAnalysis(fromDate, toDate);
            YearAnalysis(fromDate, toDate);
        }
    }

    //分析
    protected void FenxiButton_Click(object sender, EventArgs e)
    {
        CheckSession();

        string fDate = FromText.Text.ToString();
        string tDate = ToText.Text.ToString();

        Shouru(fDate, tDate);
        ServerType(fDate, tDate);
        DayAnalysis(fDate, tDate);
        MonthAnalysis(fDate, tDate);
    }

    protected void CheckSession()
    {
        if (Session["uname"] == null)
        {
            Response.Redirect("../Login.aspx");
        }
    }

    //总体收入分析
    protected void Shouru(string fromDate, string toDate)
    {
        decimal[] result = ShouruSelect(fromDate, toDate);

        shouru_tab1_x = "['会员充值收入','未支付金额','收衣取衣收入','衣物赔付金额','合计收入']";
        shouru_tab1_y = "[{name: '收入项目',data: [" + result[0].ToString("f2") + ","
            + result[1].ToString("f2") + "," + result[2].ToString("f2") + ","
            + result[3].ToString("f2") + "," + result[4].ToString("f2") + "] }]";

        DataTable ShouruTable = new DataTable();
        DataColumn ditem = new DataColumn("收入项目", Type.GetType("System.String"));
        DataColumn dnum = new DataColumn("金额", Type.GetType("System.Decimal"));
        ShouruTable.Columns.Add(ditem);
        ShouruTable.Columns.Add(dnum);

        DataRow dr1 = ShouruTable.NewRow();
        dr1["收入项目"] = "会员充值收入";
        dr1["金额"] = result[0].ToString("f2");
        ShouruTable.Rows.Add(dr1);

        DataRow dr2 = ShouruTable.NewRow();
        dr2["收入项目"] = "未支付金额";
        dr2["金额"] = result[1].ToString("f2");
        ShouruTable.Rows.Add(dr2);

        DataRow dr3 = ShouruTable.NewRow();
        dr3["收入项目"] = "收衣取衣收入";
        dr3["金额"] = result[2].ToString("f2");
        ShouruTable.Rows.Add(dr3);

        DataRow dr4 = ShouruTable.NewRow();
        dr4["收入项目"] = "衣物赔付金额";
        dr4["金额"] = result[3].ToString("f2");
        ShouruTable.Rows.Add(dr4);

        DataRow dr5 = ShouruTable.NewRow();
        dr5["收入项目"] = "合计";
        dr5["金额"] = result[4].ToString("f2");
        ShouruTable.Rows.Add(dr5);

        GridView1.DataSource = ShouruTable;
        GridView1.DataBind();
    }

    //总体收入-查询
    protected decimal[] ShouruSelect(string fromDate, string toDate)
    {
        //会员充值收入
        decimal s_chongzhi_cash = 0;
        string sql_chongzhi = "select * from MemberChongzhi where CONVERT(varchar(10), ChongzhiDate, 23) >= '" + fromDate
            + "' and CONVERT(varchar(10), ChongzhiDate, 23) <= '" + toDate + "'";
        DataSet chongzhi_ds = Common.dataSet(sql_chongzhi);
        int chongzhi_count = chongzhi_ds.Tables[0].Rows.Count;
        if (chongzhi_count > 0)
        {
            for (int i = 0; i < chongzhi_count; i++)
            {
                DataRow drow = chongzhi_ds.Tables[0].Rows[i];
                s_chongzhi_cash += Convert.ToDecimal(drow["ShishouMoney"]);
            }
        }

        //未支付金额、收衣取衣收入
        decimal s_shouqu_pay = 0;
        decimal s_shouqu_nopay = 0;
        string sql_shouqu_pay = "select * from Shouyi where [ISpay]='是' and CONVERT(varchar(10), PayDate, 23) >= '"
            + fromDate + "' and CONVERT(varchar(10), PayDate, 23) <= '" + toDate + "'";
        string sql_shouqu_nopay = "select * from Shouyi where [ISpay]='否' and CONVERT(varchar(10), ShouyiDate, 23) >= '"
            + fromDate + "' and CONVERT(varchar(10), ShouyiDate, 23) <= '" + toDate + "'";
        DataSet shouqu_ds_pay = Common.dataSet(sql_shouqu_pay);
        int shouqu_count_pay = shouqu_ds_pay.Tables[0].Rows.Count;
        if (shouqu_count_pay > 0)
        {
            for (int i = 0; i < shouqu_count_pay; i++)
            {
                DataRow drow = shouqu_ds_pay.Tables[0].Rows[i];
                s_shouqu_pay += Convert.ToDecimal(drow["Yingshou"]);
            }
        }
        DataSet shouqu_ds_nopay = Common.dataSet(sql_shouqu_nopay);
        int shouqu_count_nopay = shouqu_ds_nopay.Tables[0].Rows.Count;
        if (shouqu_count_nopay > 0)
        {
            for (int i = 0; i < shouqu_count_nopay; i++)
            {
                DataRow drow = shouqu_ds_nopay.Tables[0].Rows[i];
                s_shouqu_nopay += Convert.ToDecimal(drow["Yingshou"]);
            }
        }

        //赔付金额
        decimal s_tuipei = 0;
        string sql_tuipei = "select * from WashFail where CONVERT(varchar(10), RestituteDate, 23) >= '" + fromDate
            + "' and CONVERT(varchar(10), RestituteDate, 23) <= '" + toDate + "'";
        DataSet tuipei_ds = Common.dataSet(sql_tuipei);
        int tuipei_count = tuipei_ds.Tables[0].Rows.Count;
        if (tuipei_count > 0)
        {
            for (int i = 0; i < tuipei_count; i++)
            {
                DataRow drow = tuipei_ds.Tables[0].Rows[i];
                s_tuipei -= Convert.ToDecimal(drow["RestituteMoney"]);
            }
        }

        //合计金额
        decimal s_total = s_chongzhi_cash + s_shouqu_pay + s_shouqu_nopay + s_tuipei;

        decimal[] result = { s_chongzhi_cash, s_shouqu_nopay, s_shouqu_pay, s_tuipei, s_total };
        return result;
    }

    //洗衣类型分析
    protected void ServerType(string fromDate, string toDate)
    {
        string sql = "select ServerName as 洗衣类型, CONVERT(decimal(18,2), Sum(TotalPrice) ) as 金额 from ShouyiDetail,Clothes where"
            + " ShouyiID in (select ShouyiID from Shouyi where IsPay='是' and CONVERT(varchar(10), PayDate, 23) >= '"
            + fromDate + "' and CONVERT(varchar(10), PayDate, 23) <= '" + toDate + "')"
            + " and ShouyiDetail.ClothesID = Clothes.ClothesID group by ServerName";
        DataSet ds = Common.dataSet(sql);
        GridView2.DataSource = ds.Tables[0];
        GridView2.DataBind();

        int ds_count = ds.Tables[0].Rows.Count;
        if (ds_count > 0)
        {
            server_tab2_x += "[";
            server_tab2_y += "[{name: '洗衣类型',data: [";
            for (int i = 0; i < ds_count; i++)
            {
                DataRow drow = ds.Tables[0].Rows[i];
                server_tab2_x += "'" + drow["洗衣类型"].ToString() + "',";
                server_tab2_y += drow["金额"].ToString() + ",";
            }
            server_tab2_x = server_tab2_x.Substring(0, server_tab2_x.Length - 1);
            server_tab2_x += "]";
            server_tab2_y = server_tab2_y.Substring(0, server_tab2_y.Length - 1);
            server_tab2_y += "] }]";
        }
        if (ds_count == 0)
        {
            server_tab2_x = "['']";
            server_tab2_y = "[{name: '洗衣类型',data: [] }]";
        }
    }

    //按日分析,默认只分析15天的数据
    protected void DayAnalysis(string fromDate, string toDate)
    {
        string shouyi_sql = "select top 15 日期, CONVERT(decimal(18,2), Sum(金额) ) as 金额 from TongjiShouyiView where 日期 <= '" 
            + toDate + "' group by 日期";
        DataSet shouyi_ds = Common.dataSet(shouyi_sql);
        GridView3.DataSource = shouyi_ds.Tables[0];
        GridView3.DataBind();

        int shouyi_count = shouyi_ds.Tables[0].Rows.Count;
        if (shouyi_count > 0)
        {
            for (int i = 0; i < shouyi_count; i++)
            {
                DataRow drow = shouyi_ds.Tables[0].Rows[i];
                day_tab3_x += "'" + drow["日期"].ToString() + "',";
                day_tab3_y += drow["金额"].ToString() + ",";
            }
            day_tab3_x = day_tab3_x.Substring(0, day_tab3_x.Length - 1);
            day_tab3_y = day_tab3_y.Substring(0, day_tab3_y.Length - 1);
        }
    }

    //按月分析，默认只分析12个月
    protected void MonthAnalysis(string fromDate, string toDate)
    {
        string month_sql = "select top 12 月份, CONVERT(decimal(18,2), Sum(金额) ) as 金额 from TongjiMonthView where 月份 <= '"
            + toDate.Substring(0, 7) + "' group by 月份";
        DataSet month_ds = Common.dataSet(month_sql);
        GridView4.DataSource = month_ds.Tables[0];
        GridView4.DataBind();

        int month_count = month_ds.Tables[0].Rows.Count;
        if (month_count > 0)
        {
            for (int i = 0; i < month_count; i++)
            {
                DataRow drow = month_ds.Tables[0].Rows[i];
                month_tab4_x += "'" + drow["月份"].ToString() + "',";
                month_tab4_y += drow["金额"].ToString() + ",";
            }
            month_tab4_x = month_tab4_x.Substring(0, month_tab4_x.Length - 1);
            month_tab4_y = month_tab4_y.Substring(0, month_tab4_y.Length - 1);
        }
    }

    //按年份分析，只分析6年
    protected void YearAnalysis(string fromDate, string toDate)
    {
        string year_sql = "select top 6 年份, CONVERT(decimal(18,2), Sum(金额) ) as 金额 from TongjiYearView where 年份 <= '"
            + toDate.Substring(0, 4) + "' group by 年份";
        DataSet year_ds = Common.dataSet(year_sql);
        GridView5.DataSource = year_ds.Tables[0];
        GridView5.DataBind();

        int year_count = year_ds.Tables[0].Rows.Count;
        if (year_count > 0)
        {
            for (int i = 0; i < year_count; i++)
            {
                DataRow drow = year_ds.Tables[0].Rows[i];
                year_tab5_x += "'" + drow["年份"].ToString() + "',";
                year_tab5_y += drow["金额"].ToString() + ",";
            }
            year_tab5_x = year_tab5_x.Substring(0, year_tab5_x.Length - 1);
            year_tab5_y = year_tab5_y.Substring(0, year_tab5_y.Length - 1);
        }
    }
}