﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Data;
using System.Data.SqlClient;
using System.Xml;

public partial class XitongGuanli_DataBase : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        ClientScript.RegisterStartupScript(ClientScript.GetType(), "myscript", "<script>clickmenu(5);</script>");
        CheckSession();
        string current_user = Session["uname"].ToString();
        string s1 = "Select UserType from [User] where UserName='" + current_user + "'";
        string current_type = Common.GetName(s1, 0);
        if (current_type == "营业员")
        {
            Response.Write("<script>alert('你无权查看此页面！'); location.href='../ShouyiQuyi/Shouyi.aspx';</script>");
        }
        Label_BackDir.Text = Server.MapPath("~/BackUp");
        if (!Page.IsPostBack)
        {
            loadbox();
        }
    }

    protected void CheckSession()
    {
        if (Session["uname"] == null)
        {
            Response.Redirect("../Login.aspx");
        }
    }

    //备份
    protected void Button_Backup_Click(object sender, EventArgs e)
    {
        CheckSession();
        try
        {
            string dir = Label_BackDir.Text.Trim().ToString();
            string sql = "backup database WashClothes to Disk='" + dir + "\\" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".dbsh'";
            Common.ExecuteSql(sql);
            ClientScript.RegisterStartupScript(this.GetType(), "script1", "<script>alert('数据库备份成功,请自行保存好备份文件。');</script>");
        }
        catch
        {
            ClientScript.RegisterStartupScript(this.GetType(), "script2", "<script>alert('数据库备份失败!');</script>");
        }
    }

    //退出时自动备份数据库
    protected void CheckBox_AutoBackup_CheckedChanged(object sender, EventArgs e)
    {
        CheckSession();
        XmlDocument back = new XmlDocument();
        string path = Server.MapPath("~/xml.xml");
        back.Load(path);
        string pa = "Config/Backup/AutoBackup";
        XmlNode node = back.SelectSingleNode(pa);
        if (CheckBox_AutoBackup.Checked == true)
        {
            node.InnerText = "1";
        }
        else
        {
            node.InnerText = "0";
        }
        back.Save(path);
        ClientScript.RegisterStartupScript(this.GetType(), "script5", "<script>alert('更新成功');</script>");
    }

    //读取xml,更新checkbox
    protected void loadbox()
    {
        XmlDocument back = new XmlDocument();
        back.Load(Server.MapPath("~/xml.xml"));
        string path = "Config/Backup/AutoBackup";
        string auto = back.SelectSingleNode(path).InnerText.ToString();
        if (auto == "1")
        {
            CheckBox_AutoBackup.Checked = true;
        }
        else
        {
            CheckBox_AutoBackup.Checked = false;
        }
    }

    //数据库恢复
    protected void Button_Recover_Click(object sender, EventArgs e)
    {
        CheckSession();
        string dir = Label_BackDir.Text.Trim().ToString();
        string file = dir + "\\" + FileUpload1.PostedFile.FileName;
        if(!FileUpload1.HasFile)
        {
            ClientScript.RegisterStartupScript(this.GetType(), "script5", "<script>alert('请先选择要恢复的数据库文件！');</script>");
        }
        else if(!CheckFileType(FileUpload1))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "script6", "<script>alert('扩展名有误，请选择正确的恢复文件！');</script>");
        }
        else if (!Common.IsFileExist(file))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "scriptexist", "<script>alert('你选择的文件不存在，请将文件放在备份目录下！');</script>");
        }
        else
        {
            string connectionStr = "Data Source=.;Initial Catalog=Master;Integrated Security=True";
            string sq = "restore database WashClothes from Disk='" + file + "' with replace";
            string sq1 = "Use Master";
            string sq2 = "ALTER DATABASE [WashClothes] SET OFFLINE WITH ROLLBACK IMMEDIATE";
            string sq3 = "alter database WashClothes set online";

            using (SqlConnection conn = new SqlConnection(connectionStr))
            {
                conn.Open();
                try
                {
                    SqlCommand cmd = new SqlCommand();
                    cmd.Connection = conn;

                    cmd.CommandText = sq1;//使用master数据库
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = sq2;//把要恢复的数据库设置为脱机模式
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = sq;//执行恢复语句
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = sq3;//转为联机模式
                    cmd.ExecuteNonQuery();

                    SqlConnection.ClearAllPools();

                    //记录到日志中
                    string logevent = "数据恢复成功";
                    Common.GenerateLog(Session["uname"].ToString(), logevent);
                    ClientScript.RegisterStartupScript(this.GetType(), "Test2", "<script>alert('数据恢复成功');</script>");
                }
                catch (Exception ex)
                {
                    throw ex;
                }
                finally
                {
                    conn.Close();
                }
            }
        } 
    }

    //检查文件类型
    protected bool CheckFileType(FileUpload File)
    {
        string fileName = File.FileName;
        Boolean fileOK = false; 
        String fileExtension = System.IO.Path.GetExtension(File.FileName).ToLower();
        if (fileExtension == ".dbsh")
        {
            fileOK = true;
        }   
        return fileOK;
    }

    //数据清空
    protected void Button_Clear_Click(object sender, EventArgs e)
    {
        CheckSession();
        string del_shouyi = "delete from [Shouyi]";
        string del_washAgain = "delete from [WashAgain]";
        string del_washCancel = "delete from [WashCancel]";
        string del_washFail = "delete from [WashFail]";

        string del_member = "delete from [Member]";
        string del_cardreturn = "delete from [MemberCardReturn]";

        if (CheckBox_Shouyi.Checked && CheckBox_Member.Checked)
        {
            Common.ExecuteSql(del_member);
            Common.ExecuteSql(del_cardreturn);

            //记录到日志中
            string logevent = "删除销售信息、删除会员信息";
            Common.GenerateLog(Session["uname"].ToString(), logevent);
        }
        else if (CheckBox_Shouyi.Checked && !CheckBox_Member.Checked)
        {
            Common.ExecuteSql(del_shouyi);
            Common.ExecuteSql(del_washAgain);
            Common.ExecuteSql(del_washCancel);
            Common.ExecuteSql(del_washFail);

            //记录到日志中
            string logevent = "删除销售信息";
            Common.GenerateLog(Session["uname"].ToString(), logevent);
        }
        else if (!CheckBox_Shouyi.Checked && CheckBox_Member.Checked)
        {
            ClientScript.RegisterStartupScript(this.GetType(), "del1", "<script>alert('错误，要删除会员信息，必须同时选择删除销售信息！');</script>");
            return;
        }
        else if (!CheckBox_Shouyi.Checked && !CheckBox_Member.Checked)
        {
            ClientScript.RegisterStartupScript(this.GetType(), "del2", "<script>alert('错误，请先选择要清空的数据！');</script>");
            return;
        }
        ClientScript.RegisterStartupScript(this.GetType(), "del3", "<script>alert('删除成功！');</script>");
    }
}