﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class XitongGuanli_UserAdmin : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        ClientScript.RegisterStartupScript(ClientScript.GetType(), "myscript", "<script>clickmenu(5);</script>");
    }

    protected void CheckSession()
    {
        if (Session["uname"] == null)
        {
            Response.Redirect("../Login.aspx");
        }
    }

    //更新
    protected void GridView1_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        CheckSession();
        string id = GridView1.DataKeys[e.RowIndex].Value.ToString();
        string pa = ((TextBox)GridView1.Rows[e.RowIndex].FindControl("password")).Text.Trim().ToString();
        string ty = ((DropDownList)GridView1.Rows[e.RowIndex].FindControl("DropDownList1")).SelectedValue.ToString();
        if (String.IsNullOrEmpty(pa))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "script5", "<script>alert('密码不能为空,修改失败！')</script>");
        }
        else
        {
            string sq = "Update [User] set UserPassword='" + pa + "',UserType='" + ty + "' where UserID='" + id + "'";
            Common.ExecuteSql(sq);
            GridView1.DataBind();
        }
    }

    //删除
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        CheckSession();
        string current_user = Session["uname"].ToString();
        string s1 = "Select UserType from [User] where UserName='" + current_user + "'";
        string current_type = Common.GetName(s1, 0);
        string user = ((Label)GridView1.Rows[e.RowIndex].FindControl("Label_User1")).Text;
        string type = ((Label)GridView1.Rows[e.RowIndex].FindControl("Label_type")).Text;
        if (user != current_user)
        {
            if (current_type == "管理员")
            {
                if (current_user != "admin")//admin账户作为默认的超级管理员
                {
                    if (type != "营业员")
                    {
                        ClientScript.RegisterStartupScript(this.GetType(), "script3", "<script>alert('你没有权限删除其他管理员的账户！')</script>");
                        e.Cancel = true;
                    }
                }
                else//是管理员，删除用户，同时删除临时表
                {
                    string deltemp = "drop table [temp-" + user + "]";
                    Common.ExecuteSql(deltemp);
                }
            }
            else
            {
                ClientScript.RegisterStartupScript(this.GetType(), "script2", "<script>alert('你没有权限删除别人的账户！')</script>");
                e.Cancel = true;
            }
        }
        else
        {
            ClientScript.RegisterStartupScript(this.GetType(), "script1", "<script>alert('你不能删除自己的账户！')</script>");
            e.Cancel = true;
        }
    }

    //编辑
    protected void GridView1_RowEditing(object sender, GridViewEditEventArgs e)
    {
        CheckSession();
        string current_user = Session["uname"].ToString();
        string s1 = "Select UserType from [User] where UserName='" + current_user + "'";
        string current_type = Common.GetName(s1, 0);
        string user = ((Label)GridView1.Rows[e.NewEditIndex].FindControl("Label_User1")).Text;
        string type = ((Label)GridView1.Rows[e.NewEditIndex].FindControl("Label_type")).Text;
        if (user != current_user)
        {
            if (current_type == "管理员")
            {
                if (current_user != "admin")//admin账户作为默认的超级管理员
                {
                    if (type != "营业员")
                    {
                        ClientScript.RegisterStartupScript(this.GetType(), "script3", "<script>alert('你没有权限修改其他管理员的信息！')</script>");
                        e.Cancel = true;
                    }
                }
            }
            else
            {
                ClientScript.RegisterStartupScript(this.GetType(), "script2", "<script>alert('你没有权限修改别人的信息！')</script>");
                e.Cancel = true;
            }
        }
    }

    protected void GridView1_PreRender(object sender, EventArgs e)
    {
        CheckSession();
        string current_user = Session["uname"].ToString();
        string s1 = "Select UserType from [User] where UserName='" + current_user + "'";
        string current_type = Common.GetName(s1, 0);
        if (current_type == "营业员")
        {
            SqlDataSource1.SelectCommand = "Select * from [User] where UserName='" + current_user + "'";
            GridView1.ShowFooter = false;
        }
        DropDownList list = (DropDownList)GridView1.FooterRow.FindControl("DropDownList2");
        if (current_user != "admin")
        {
            if(list.Items.FindByText("管理员") != null)
            {
                list.Items.Remove(list.Items.FindByText("管理员"));
            }
        }
    }

    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        CheckSession();
        string current_user = Session["uname"].ToString();
        string s1 = "Select UserType from [User] where UserName='" + current_user + "'";
        string current_type = Common.GetName(s1, 0);
        
        if ((e.Row.RowState & DataControlRowState.Edit) == DataControlRowState.Edit)
        {
            string na = ((Label)e.Row.FindControl("Label_User")).Text;
            if (current_type == "营业员" || current_user != "admin" || na=="admin")
            {
                ((DropDownList)e.Row.FindControl("DropDownList1")).Enabled = false;
            }
        }
    }

    //添加用户
    protected void ButtonAdd_Click(object sender, EventArgs e)
    {
        CheckSession();
        TextBox us = (TextBox)GridView1.FooterRow.FindControl("Text_User");
        string user = us.Text.Trim().ToString();
        string password = ((TextBox)GridView1.FooterRow.FindControl("Text_Pa")).Text.Trim().ToString();
        string type = ((DropDownList)GridView1.FooterRow.FindControl("DropDownList2")).SelectedValue.ToString();

        string ss1 = "Select UserName from [User] where UserName='" + user + "'";

        if (String.IsNullOrEmpty(user) || String.IsNullOrEmpty(password) || String.IsNullOrEmpty(type))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "new1", "<script>alert('不允许为空！')</script>");
        }
        else if (Common.Check(us, ss1))
        {
            ClientScript.RegisterStartupScript(this.GetType(), "new2", "<script>alert('不允许插入已有的用户名！')</script>");
        }
        else
        {
            string ss2 = "Insert into [User](UserName,UserPassword,UserType) values('" + user + "','" + password + "','" + type + "')";
            Common.ExecuteSql(ss2);
            GridView1.DataBind();
            
            //创建用户的临时收衣表
            string createtemp = "Create table [temp-" + user
            + "]([ShouyiDetailID] [nvarchar](20) primary key NOT NULL,"
	        + "[ClothesName] [nvarchar](20) NOT NULL,"
	        + "[ServerName] [nvarchar](20) NOT NULL,"
	        + "[ClothesColorName] [nvarchar](10) NOT NULL,"
	        + "[ClothesBrandName] [nvarchar](20) NOT NULL,"
	        + "[ClothesAttachmentName] [nvarchar](50) NOT NULL,"
	        + "[ClothesBlemishName] [nvarchar](50) NOT NULL,"
	        + "[AdditionalService] [nvarchar](50) NOT NULL,"
	        + "[AdditionalPrice] [money] NOT NULL,"
	        + "[PlaceNo] [nvarchar](10) NOT NULL,"
	        + "[ClothesNumber] [int] NOT NULL,"
	        + "[WashPrice] [money] NOT NULL,"
	        + "[Discount] [float] NOT NULL,"
	        + "[TotalPrice] [money] NOT NULL)";
            Common.ExecuteSql(createtemp);
        }
    }
}